% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_create_index}
\alias{clouddirectory_create_index}
\title{Creates an index object}
\usage{
clouddirectory_create_index(
  DirectoryArn,
  OrderedIndexedAttributeList,
  IsUnique,
  ParentReference = NULL,
  LinkName = NULL
)
}
\arguments{
\item{DirectoryArn}{[required] The ARN of the directory where the index should be created.}

\item{OrderedIndexedAttributeList}{[required] Specifies the attributes that should be indexed on. Currently only a
single attribute is supported.}

\item{IsUnique}{[required] Indicates whether the attribute that is being indexed has unique values
or not.}

\item{ParentReference}{A reference to the parent object that contains the index object.}

\item{LinkName}{The name of the link between the parent object and the index object.}
}
\description{
Creates an index object. See \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html}{Indexing and search} for more information.

See \url{https://paws-r.github.io/docs/clouddirectory/create_index.html} for full documentation.
}
\keyword{internal}
