% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_upgrade_published_schema}
\alias{clouddirectory_upgrade_published_schema}
\title{Upgrades a published schema under a new minor version revision using the
current contents of DevelopmentSchemaArn}
\usage{
clouddirectory_upgrade_published_schema(
  DevelopmentSchemaArn,
  PublishedSchemaArn,
  MinorVersion,
  DryRun = NULL
)
}
\arguments{
\item{DevelopmentSchemaArn}{[required] The ARN of the development schema with the changes used for the upgrade.}

\item{PublishedSchemaArn}{[required] The ARN of the published schema to be upgraded.}

\item{MinorVersion}{[required] Identifies the minor version of the published schema that will be
created. This parameter is NOT optional.}

\item{DryRun}{Used for testing whether the Development schema provided is backwards
compatible, or not, with the publish schema provided by the user to be
upgraded. If schema compatibility fails, an exception would be thrown
else the call would succeed. This parameter is optional and defaults to
false.}
}
\description{
Upgrades a published schema under a new minor version revision using the current contents of \code{DevelopmentSchemaArn}.

See \url{https://paws-r.github.io/docs/clouddirectory/upgrade_published_schema.html} for full documentation.
}
\keyword{internal}
