% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_list_findings}
\alias{guardduty_list_findings}
\title{Lists Amazon GuardDuty findings for the specified detector ID}
\usage{
guardduty_list_findings(
  DetectorId,
  FindingCriteria = NULL,
  SortCriteria = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DetectorId}{[required] The ID of the detector that specifies the GuardDuty service whose
findings you want to list.}

\item{FindingCriteria}{Represents the criteria used for querying findings. Valid values
include:
\itemize{
\item JSON field name
\item accountId
\item region
\item confidence
\item id
\item resource.accessKeyDetails.accessKeyId
\item resource.accessKeyDetails.principalId
\item resource.accessKeyDetails.userName
\item resource.accessKeyDetails.userType
\item resource.instanceDetails.iamInstanceProfile.id
\item resource.instanceDetails.imageId
\item resource.instanceDetails.instanceId
\item resource.instanceDetails.networkInterfaces.ipv6Addresses
\item resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
\item resource.instanceDetails.networkInterfaces.publicDnsName
\item resource.instanceDetails.networkInterfaces.publicIp
\item resource.instanceDetails.networkInterfaces.securityGroups.groupId
\item resource.instanceDetails.networkInterfaces.securityGroups.groupName
\item resource.instanceDetails.networkInterfaces.subnetId
\item resource.instanceDetails.networkInterfaces.vpcId
\item resource.instanceDetails.tags.key
\item resource.instanceDetails.tags.value
\item resource.resourceType
\item service.action.actionType
\item service.action.awsApiCallAction.api
\item service.action.awsApiCallAction.callerType
\item service.action.awsApiCallAction.remoteIpDetails.city.cityName
\item service.action.awsApiCallAction.remoteIpDetails.country.countryName
\item service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
\item service.action.awsApiCallAction.remoteIpDetails.organization.asn
\item service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
\item service.action.awsApiCallAction.serviceName
\item service.action.dnsRequestAction.domain
\item service.action.networkConnectionAction.blocked
\item service.action.networkConnectionAction.connectionDirection
\item service.action.networkConnectionAction.localPortDetails.port
\item service.action.networkConnectionAction.protocol
\item service.action.networkConnectionAction.remoteIpDetails.country.countryName
\item service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
\item service.action.networkConnectionAction.remoteIpDetails.organization.asn
\item service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
\item service.action.networkConnectionAction.remotePortDetails.port
\item service.additionalInfo.threatListName
\item service.archived

When this attribute is set to 'true', only archived findings are
listed. When it's set to 'false', only unarchived findings are
listed. When this attribute is not set, all existing findings are
listed.
\item service.resourceRole
\item severity
\item type
\item updatedAt

Type: Timestamp in Unix Epoch millisecond format: 1486685375000
}}

\item{SortCriteria}{Represents the criteria used for sorting findings.}

\item{MaxResults}{You can use this parameter to indicate the maximum number of items you
want in the response. The default value is 50. The maximum value is 50.}

\item{NextToken}{You can use this parameter when paginating results. Set the value of
this parameter to null on your first call to the list action. For
subsequent calls to the action, fill nextToken in the request with the
value of NextToken from the previous response to continue listing data.}
}
\description{
Lists Amazon GuardDuty findings for the specified detector ID.

See \url{https://paws-r.github.io/docs/guardduty/list_findings.html} for full documentation.
}
\keyword{internal}
