% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_instance_profile}
\alias{iam_create_instance_profile}
\title{Creates a new instance profile}
\usage{
iam_create_instance_profile(InstanceProfileName, Path = NULL, Tags = NULL)
}
\arguments{
\item{InstanceProfileName}{[required] The name of the instance profile to create.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Path}{The path to the instance profile. For more information about paths, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{Tags}{A list of tags that you want to attach to the newly created IAM instance
profile. Each tag consists of a key name and an associated value. For
more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not
created.}
}
\description{
Creates a new instance profile. For information about instance profiles, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html}{Using roles for applications on Amazon EC2} in the \emph{IAM User Guide}, and \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile}{Instance profiles} in the \emph{Amazon EC2 User Guide}.

See \url{https://paws-r.github.io/docs/iam/create_instance_profile.html} for full documentation.
}
\keyword{internal}
