% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_organizations_access_report}
\alias{iam_get_organizations_access_report}
\title{Retrieves the service last accessed data report for Organizations that
was previously generated using the GenerateOrganizationsAccessReport
operation}
\usage{
iam_get_organizations_access_report(
  JobId,
  MaxItems = NULL,
  Marker = NULL,
  SortKey = NULL
)
}
\arguments{
\item{JobId}{[required] The identifier of the request generated by the
\code{\link[=iam_generate_organizations_access_report]{generate_organizations_access_report}}
operation.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{SortKey}{The key that is used to sort the results. If you choose the namespace
key, the results are returned in alphabetical order. If you choose the
time key, the results are sorted numerically by the date and time.}
}
\description{
Retrieves the service last accessed data report for Organizations that was previously generated using the \code{\link[=iam_generate_organizations_access_report]{generate_organizations_access_report}} operation. This operation retrieves the status of your report job and the report contents.

See \url{https://paws-r.github.io/docs/iam/get_organizations_access_report.html} for full documentation.
}
\keyword{internal}
