% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_upload_server_certificate}
\alias{iam_upload_server_certificate}
\title{Uploads a server certificate entity for the Amazon Web Services account}
\usage{
iam_upload_server_certificate(
  Path = NULL,
  ServerCertificateName,
  CertificateBody,
  PrivateKey,
  CertificateChain = NULL,
  Tags = NULL
)
}
\arguments{
\item{Path}{The path for the server certificate. For more information about paths,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/). This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.

If you are uploading a server certificate specifically for use with
Amazon CloudFront distributions, you must specify a path using the
\code{path} parameter. The path must begin with \verb{/cloudfront} and must
include a trailing slash (for example, \verb{/cloudfront/test/}).}

\item{ServerCertificateName}{[required] The name for the server certificate. Do not include the path in this
value. The name of the certificate cannot contain any spaces.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{CertificateBody}{[required] The contents of the public key certificate in PEM-encoded format.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{PrivateKey}{[required] The contents of the private key in PEM-encoded format.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{CertificateChain}{The contents of the certificate chain. This is typically a concatenation
of the PEM-encoded public key certificates of the chain.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{Tags}{A list of tags that you want to attach to the new IAM server certificate
resource. Each tag consists of a key name and an associated value. For
more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not
created.}
}
\description{
Uploads a server certificate entity for the Amazon Web Services account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.

See \url{https://paws-r.github.io/docs/iam/upload_server_certificate.html} for full documentation.
}
\keyword{internal}
