% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_list_attacks}
\alias{shield_list_attacks}
\title{Returns all ongoing DDoS attacks or all DDoS attacks during a specified
time period}
\usage{
shield_list_attacks(
  ResourceArns = NULL,
  StartTime = NULL,
  EndTime = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceArns}{The ARNs (Amazon Resource Names) of the resources that were attacked. If
you leave this blank, all applicable resources for this account will be
included.}

\item{StartTime}{The start of the time period for the attacks. This is a \code{timestamp}
type. The request syntax listing for this call indicates a \code{number}
type, but you can provide the time in any valid \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp}{timestamp format}
setting.}

\item{EndTime}{The end of the time period for the attacks. This is a \code{timestamp} type.
The request syntax listing for this call indicates a \code{number} type, but
you can provide the time in any valid \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp}{timestamp format}
setting.}

\item{NextToken}{When you request a list of objects from Shield Advanced, if the response
does not include all of the remaining available objects, Shield Advanced
includes a \code{NextToken} value in the response. You can retrieve the next
batch of objects by requesting the list again and providing the token
that was returned by the prior call in your request.

You can indicate the maximum number of objects that you want Shield
Advanced to return for a single call with the \code{MaxResults} setting.
Shield Advanced will not return more than \code{MaxResults} objects, but may
return fewer, even if more objects are still available.

Whenever more objects remain that Shield Advanced has not yet returned
to you, the response will include a \code{NextToken} value.

On your first call to a list operation, leave this setting empty.}

\item{MaxResults}{The greatest number of objects that you want Shield Advanced to return
to the list request. Shield Advanced might return fewer objects than you
indicate in this setting, even if more objects are available. If there
are more objects remaining, Shield Advanced will always also return a
\code{NextToken} value in the response.

The default setting is 20.}
}
\description{
Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.

See \url{https://paws-r.github.io/docs/shield/list_attacks.html} for full documentation.
}
\keyword{internal}
