% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_list_resources_for_web_acl}
\alias{wafv2_list_resources_for_web_acl}
\title{Retrieves an array of the Amazon Resource Names (ARNs) for the regional
resources that are associated with the specified web ACL}
\usage{
wafv2_list_resources_for_web_acl(WebACLArn, ResourceType = NULL)
}
\arguments{
\item{WebACLArn}{[required] The Amazon Resource Name (ARN) of the web ACL.}

\item{ResourceType}{Used for web ACLs that are scoped for regional applications. A regional
application can be an Application Load Balancer (ALB), an Amazon API
Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user
pool.}
}
\description{
Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call \code{ListDistributionsByWebACLId}.

See \url{https://paws-r.github.io/docs/wafv2/list_resources_for_web_acl.html} for full documentation.
}
\keyword{internal}
