% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_service.R
\name{accessanalyzer}
\alias{accessanalyzer}
\title{Access Analyzer}
\usage{
accessanalyzer(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Identity and Access Management Access Analyzer helps identify potential
resource-access risks by enabling you to identify any policies that
grant access to an external principal. It does this by using logic-based
reasoning to analyze resource-based policies in your Amazon Web Services
environment. An external principal can be another Amazon Web Services
account, a root user, an IAM user or role, a federated user, an Amazon
Web Services service, or an anonymous user. You can also use IAM Access
Analyzer to preview and validate public and cross-account access to your
resources before deploying permissions changes. This guide describes the
Identity and Access Management Access Analyzer operations that you can
call programmatically. For general information about IAM Access
Analyzer, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html}{Identity and Access Management Access Analyzer}
in the \strong{IAM User Guide}.

To start using IAM Access Analyzer, you first need to create an
analyzer.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- accessanalyzer(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=accessanalyzer_apply_archive_rule]{apply_archive_rule} \tab Retroactively applies the archive rule to existing findings that meet the archive rule criteria\cr
\link[=accessanalyzer_cancel_policy_generation]{cancel_policy_generation} \tab Cancels the requested policy generation\cr
\link[=accessanalyzer_create_access_preview]{create_access_preview} \tab Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions\cr
\link[=accessanalyzer_create_analyzer]{create_analyzer} \tab Creates an analyzer for your account\cr
\link[=accessanalyzer_create_archive_rule]{create_archive_rule} \tab Creates an archive rule for the specified analyzer\cr
\link[=accessanalyzer_delete_analyzer]{delete_analyzer} \tab Deletes the specified analyzer\cr
\link[=accessanalyzer_delete_archive_rule]{delete_archive_rule} \tab Deletes the specified archive rule\cr
\link[=accessanalyzer_get_access_preview]{get_access_preview} \tab Retrieves information about an access preview for the specified analyzer\cr
\link[=accessanalyzer_get_analyzed_resource]{get_analyzed_resource} \tab Retrieves information about a resource that was analyzed\cr
\link[=accessanalyzer_get_analyzer]{get_analyzer} \tab Retrieves information about the specified analyzer\cr
\link[=accessanalyzer_get_archive_rule]{get_archive_rule} \tab Retrieves information about an archive rule\cr
\link[=accessanalyzer_get_finding]{get_finding} \tab Retrieves information about the specified finding\cr
\link[=accessanalyzer_get_generated_policy]{get_generated_policy} \tab Retrieves the policy that was generated using StartPolicyGeneration\cr
\link[=accessanalyzer_list_access_preview_findings]{list_access_preview_findings} \tab Retrieves a list of access preview findings generated by the specified access preview\cr
\link[=accessanalyzer_list_access_previews]{list_access_previews} \tab Retrieves a list of access previews for the specified analyzer\cr
\link[=accessanalyzer_list_analyzed_resources]{list_analyzed_resources} \tab Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer\cr
\link[=accessanalyzer_list_analyzers]{list_analyzers} \tab Retrieves a list of analyzers\cr
\link[=accessanalyzer_list_archive_rules]{list_archive_rules} \tab Retrieves a list of archive rules created for the specified analyzer\cr
\link[=accessanalyzer_list_findings]{list_findings} \tab Retrieves a list of findings generated by the specified analyzer\cr
\link[=accessanalyzer_list_policy_generations]{list_policy_generations} \tab Lists all of the policy generations requested in the last seven days\cr
\link[=accessanalyzer_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves a list of tags applied to the specified resource\cr
\link[=accessanalyzer_start_policy_generation]{start_policy_generation} \tab Starts the policy generation request\cr
\link[=accessanalyzer_start_resource_scan]{start_resource_scan} \tab Immediately starts a scan of the policies applied to the specified resource\cr
\link[=accessanalyzer_tag_resource]{tag_resource} \tab Adds a tag to the specified resource\cr
\link[=accessanalyzer_untag_resource]{untag_resource} \tab Removes a tag from the specified resource\cr
\link[=accessanalyzer_update_archive_rule]{update_archive_rule} \tab Updates the criteria and values for the specified archive rule\cr
\link[=accessanalyzer_update_findings]{update_findings} \tab Updates the status for the specified findings\cr
\link[=accessanalyzer_validate_policy]{validate_policy} \tab Requests the validation of a policy and returns a list of findings
}
}

\examples{
\dontrun{
svc <- accessanalyzer()
svc$apply_archive_rule(
  Foo = 123
)
}

}
