% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_user_pool_client}
\alias{cognitoidentityprovider_create_user_pool_client}
\title{Creates the user pool client}
\usage{
cognitoidentityprovider_create_user_pool_client(
  UserPoolId,
  ClientName,
  GenerateSecret = NULL,
  RefreshTokenValidity = NULL,
  AccessTokenValidity = NULL,
  IdTokenValidity = NULL,
  TokenValidityUnits = NULL,
  ReadAttributes = NULL,
  WriteAttributes = NULL,
  ExplicitAuthFlows = NULL,
  SupportedIdentityProviders = NULL,
  CallbackURLs = NULL,
  LogoutURLs = NULL,
  DefaultRedirectURI = NULL,
  AllowedOAuthFlows = NULL,
  AllowedOAuthScopes = NULL,
  AllowedOAuthFlowsUserPoolClient = NULL,
  AnalyticsConfiguration = NULL,
  PreventUserExistenceErrors = NULL,
  EnableTokenRevocation = NULL,
  EnablePropagateAdditionalUserContextData = NULL,
  AuthSessionValidity = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to create a user pool
client.}

\item{ClientName}{[required] The client name for the user pool client you would like to create.}

\item{GenerateSecret}{Boolean to specify whether you want to generate a secret for the user
pool client being created.}

\item{RefreshTokenValidity}{The refresh token time limit. After this limit expires, your user can't
use their refresh token. To specify the time unit for
\code{RefreshTokenValidity} as \code{seconds}, \code{minutes}, \code{hours}, or \code{days}, set
a \code{TokenValidityUnits} value in your API request.

For example, when you set \code{RefreshTokenValidity} as \code{10} and
\code{TokenValidityUnits} as \code{days}, your user can refresh their session and
retrieve new access and ID tokens for 10 days.

The default time unit for \code{RefreshTokenValidity} in an API request is
days. You can't set \code{RefreshTokenValidity} to 0. If you do, Amazon
Cognito overrides the value with the default value of 30 days. \emph{Valid
range} is displayed below in seconds.

If you don't specify otherwise in the configuration of your app client,
your refresh tokens are valid for 30 days.}

\item{AccessTokenValidity}{The access token time limit. After this limit expires, your user can't
use their access token. To specify the time unit for
\code{AccessTokenValidity} as \code{seconds}, \code{minutes}, \code{hours}, or \code{days}, set a
\code{TokenValidityUnits} value in your API request.

For example, when you set \code{AccessTokenValidity} to \code{10} and
\code{TokenValidityUnits} to \code{hours}, your user can authorize access with
their access token for 10 hours.

The default time unit for \code{AccessTokenValidity} in an API request is
hours. \emph{Valid range} is displayed below in seconds.

If you don't specify otherwise in the configuration of your app client,
your access tokens are valid for one hour.}

\item{IdTokenValidity}{The ID token time limit. After this limit expires, your user can't use
their ID token. To specify the time unit for \code{IdTokenValidity} as
\code{seconds}, \code{minutes}, \code{hours}, or \code{days}, set a \code{TokenValidityUnits}
value in your API request.

For example, when you set \code{IdTokenValidity} as \code{10} and
\code{TokenValidityUnits} as \code{hours}, your user can authenticate their
session with their ID token for 10 hours.

The default time unit for \code{AccessTokenValidity} in an API request is
hours. \emph{Valid range} is displayed below in seconds.

If you don't specify otherwise in the configuration of your app client,
your ID tokens are valid for one hour.}

\item{TokenValidityUnits}{The units in which the validity times are represented. The default unit
for RefreshToken is days, and default for ID and access tokens are
hours.}

\item{ReadAttributes}{The read attributes.}

\item{WriteAttributes}{The user pool attributes that the app client can write to.

If your app client allows users to sign in through an IdP, this array
must include all attributes that you have mapped to IdP attributes.
Amazon Cognito updates mapped attributes when users sign in to your
application through an IdP. If your app client does not have write
access to a mapped attribute, Amazon Cognito throws an error when it
tries to update the attribute. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html}{Specifying IdP Attribute Mappings for Your user pool}.}

\item{ExplicitAuthFlows}{The authentication flows that you want your user pool client to support.
For each app client in your user pool, you can sign in your users with
any combination of one or more flows, including with a user name and
Secure Remote Password (SRP), a user name and password, or a custom
authentication process that you define with Lambda functions.

If you don't specify a value for \code{ExplicitAuthFlows}, your user client
supports \code{ALLOW_REFRESH_TOKEN_AUTH}, \code{ALLOW_USER_SRP_AUTH}, and
\code{ALLOW_CUSTOM_AUTH}.

Valid values include:
\itemize{
\item \code{ALLOW_ADMIN_USER_PASSWORD_AUTH}: Enable admin based user password
authentication flow \code{ADMIN_USER_PASSWORD_AUTH}. This setting
replaces the \code{ADMIN_NO_SRP_AUTH} setting. With this authentication
flow, your app passes a user name and password to Amazon Cognito in
the request, instead of using the Secure Remote Password (SRP)
protocol to securely transmit the password.
\item \code{ALLOW_CUSTOM_AUTH}: Enable Lambda trigger based authentication.
\item \code{ALLOW_USER_PASSWORD_AUTH}: Enable user password-based
authentication. In this flow, Amazon Cognito receives the password
in the request instead of using the SRP protocol to verify
passwords.
\item \code{ALLOW_USER_SRP_AUTH}: Enable SRP-based authentication.
\item \code{ALLOW_REFRESH_TOKEN_AUTH}: Enable authflow to refresh tokens.
}

In some environments, you will see the values \code{ADMIN_NO_SRP_AUTH},
\code{CUSTOM_AUTH_FLOW_ONLY}, or \code{USER_PASSWORD_AUTH}. You can't assign these
legacy \code{ExplicitAuthFlows} values to user pool clients at the same time
as values that begin with \code{ALLOW_}, like \code{ALLOW_USER_SRP_AUTH}.}

\item{SupportedIdentityProviders}{A list of provider names for the identity providers (IdPs) that are
supported on this client. The following are supported: \code{COGNITO},
\code{Facebook}, \code{Google}, \code{SignInWithApple}, and \code{LoginWithAmazon}. You can
also specify the names that you configured for the SAML and OIDC IdPs in
your user pool, for example \code{MySAMLIdP} or \code{MyOIDCIdP}.}

\item{CallbackURLs}{A list of allowed redirect (callback) URLs for the IdPs.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{LogoutURLs}{A list of allowed logout URLs for the IdPs.}

\item{DefaultRedirectURI}{The default redirect URI. Must be in the \code{CallbackURLs} list.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{AllowedOAuthFlows}{The allowed OAuth flows.

\strong{code}

Use a code grant flow, which provides an authorization code as the
response. This code can be exchanged for access tokens with the
\verb{/oauth2/token} endpoint.

\strong{implicit}

Issue the access token (and, optionally, ID token, based on scopes)
directly to your user.

\strong{client_credentials}

Issue the access token from the \verb{/oauth2/token} endpoint directly to a
non-person user using a combination of the client ID and client secret.}

\item{AllowedOAuthScopes}{The allowed OAuth scopes. Possible values provided by OAuth are \code{phone},
\code{email}, \code{openid}, and \code{profile}. Possible values provided by Amazon Web
Services are \code{aws.cognito.signin.user.admin}. Custom scopes created in
Resource Servers are also supported.}

\item{AllowedOAuthFlowsUserPoolClient}{Set to true if the client is allowed to follow the OAuth protocol when
interacting with Amazon Cognito user pools.}

\item{AnalyticsConfiguration}{The user pool analytics configuration for collecting metrics and sending
them to your Amazon Pinpoint campaign.

In Amazon Web Services Regions where Amazon Pinpoint isn't available,
user pools only support sending events to Amazon Pinpoint projects in
Amazon Web Services Region us-east-1. In Regions where Amazon Pinpoint
is available, user pools support sending events to Amazon Pinpoint
projects within that same Region.}

\item{PreventUserExistenceErrors}{Errors and responses that you want Amazon Cognito APIs to return during
authentication, account confirmation, and password recovery when the
user doesn't exist in the user pool. When set to \code{ENABLED} and the user
doesn't exist, authentication returns an error indicating either the
username or password was incorrect. Account confirmation and password
recovery return a response indicating a code was sent to a simulated
destination. When set to \code{LEGACY}, those APIs return a
\code{UserNotFoundException} exception if the user doesn't exist in the user
pool.

Valid values include:
\itemize{
\item \code{ENABLED} - This prevents user existence-related errors.
\item \code{LEGACY} - This represents the early behavior of Amazon Cognito
where user existence related errors aren't prevented.
}}

\item{EnableTokenRevocation}{Activates or deactivates token revocation. For more information about
revoking tokens, see
\code{\link[=cognitoidentityprovider_revoke_token]{revoke_token}}.

If you don't include this parameter, token revocation is automatically
activated for the new user pool client.}

\item{EnablePropagateAdditionalUserContextData}{Activates the propagation of additional user context data. For more
information about propagation of user context data, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html}{Adding advanced security to a user pool}.
If you don’t include this parameter, you can't send device fingerprint
information, including source IP address, to Amazon Cognito advanced
security. You can only activate
\code{EnablePropagateAdditionalUserContextData} in an app client that has a
client secret.}

\item{AuthSessionValidity}{Amazon Cognito creates a session token for each API request in an
authentication flow. \code{AuthSessionValidity} is the duration, in minutes,
of that session token. Your user pool native user must respond to each
authentication challenge before the session expires.}
}
\description{
Creates the user pool client.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool_client/} for full documentation.
}
\keyword{internal}
