% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_update_rule_group}
\alias{waf_update_rule_group}
\title{This is AWS WAF Classic documentation}
\usage{
waf_update_rule_group(RuleGroupId, Updates, ChangeToken)
}
\arguments{
\item{RuleGroupId}{[required] The \code{RuleGroupId} of the RuleGroup that you want to update.
\code{RuleGroupId} is returned by
\code{\link[=waf_create_rule_group]{create_rule_group}} and by
\code{\link[=waf_list_rule_groups]{list_rule_groups}}.}

\item{Updates}{[required] An array of \code{RuleGroupUpdate} objects that you want to insert into or
delete from a RuleGroup.

You can only insert \code{REGULAR} rules into a rule group.

\code{ActivatedRule|OverrideAction} applies only when updating or adding a
\code{RuleGroup} to a \code{WebACL}. In this case you do not use
\code{ActivatedRule|Action}. For all other update requests,
\code{ActivatedRule|Action} is used instead of
\code{ActivatedRule|OverrideAction}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=waf_get_change_token]{get_change_token}}.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic} in the developer guide.

See \url{https://www.paws-r-sdk.com/docs/waf_update_rule_group/} for full documentation.
}
\keyword{internal}
