# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Key Management Service
#'
#' @description
#' Key Management Service
#' 
#' Key Management Service (KMS) is an encryption and key management web
#' service. This guide describes the KMS operations that you can call
#' programmatically. For general information about KMS, see the [*Key
#' Management Service Developer
#' Guide*](https://docs.aws.amazon.com/kms/latest/developerguide/) .
#' 
#' KMS has replaced the term *customer master key (CMK)* with *KMS key* and
#' *KMS key*. The concept has not changed. To prevent breaking changes, KMS
#' is keeping some variations of this term.
#' 
#' Amazon Web Services provides SDKs that consist of libraries and sample
#' code for various programming languages and platforms (Java, Ruby, .Net,
#' macOS, Android, etc.). The SDKs provide a convenient way to create
#' programmatic access to KMS and other Amazon Web Services services. For
#' example, the SDKs take care of tasks such as signing requests (see
#' below), managing errors, and retrying requests automatically. For more
#' information about the Amazon Web Services SDKs, including how to
#' download and install them, see [Tools for Amazon Web
#' Services](https://aws.amazon.com/developer/tools/).
#' 
#' We recommend that you use the Amazon Web Services SDKs to make
#' programmatic API calls to KMS.
#' 
#' If you need to use FIPS 140-2 validated cryptographic modules when
#' communicating with Amazon Web Services, use the FIPS endpoint in your
#' preferred Amazon Web Services Region. For more information about the
#' available FIPS endpoints, see [Service
#' endpoints](https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region)
#' in the Key Management Service topic of the *Amazon Web Services General
#' Reference*.
#' 
#' All KMS API calls must be signed and be transmitted using Transport
#' Layer Security (TLS). KMS recommends you always use the latest supported
#' TLS version. Clients must also support cipher suites with Perfect
#' Forward Secrecy (PFS) such as Ephemeral Diffie-Hellman (DHE) or Elliptic
#' Curve Ephemeral Diffie-Hellman (ECDHE). Most modern systems such as Java
#' 7 and later support these modes.
#' 
#' **Signing Requests**
#' 
#' Requests must be signed using an access key ID and a secret access key.
#' We strongly recommend that you do not use your Amazon Web Services
#' account root access key ID and secret access key for everyday work. You
#' can use the access key ID and secret access key for an IAM user or you
#' can use the Security Token Service (STS) to generate temporary security
#' credentials and use those to sign requests.
#' 
#' All KMS requests must be signed with [Signature Version
#' 4](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' **Logging API Requests**
#' 
#' KMS supports CloudTrail, a service that logs Amazon Web Services API
#' calls and related events for your Amazon Web Services account and
#' delivers them to an Amazon S3 bucket that you specify. By using the
#' information collected by CloudTrail, you can determine what requests
#' were made to KMS, who made the request, when it was made, and so on. To
#' learn more about CloudTrail, including how to turn it on and find your
#' log files, see the [CloudTrail User
#' Guide](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/).
#' 
#' **Additional Resources**
#' 
#' For more information about credentials and request signing, see the
#' following:
#' 
#' -   [Amazon Web Services Security
#'     Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/security-creds.html) -
#'     This topic provides general information about the types of
#'     credentials used to access Amazon Web Services.
#' 
#' -   [Temporary Security
#'     Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html) -
#'     This section of the *IAM User Guide* describes how to create and use
#'     temporary security credentials.
#' 
#' -   [Signature Version 4 Signing
#'     Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html) -
#'     This set of topics walks you through the process of signing a
#'     request using an access key ID and a secret access key.
#' 
#' **Commonly Used API Operations**
#' 
#' Of the API operations discussed in this guide, the following will prove
#' the most useful for most applications. You will likely perform
#' operations other than these, such as creating keys and assigning
#' policies, by using the console.
#' 
#' -   [`encrypt`][kms_encrypt]
#' 
#' -   [`decrypt`][kms_decrypt]
#' 
#' -   [`generate_data_key`][kms_generate_data_key]
#' 
#' -   [`generate_data_key_without_plaintext`][kms_generate_data_key_without_plaintext]
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- kms(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- kms()
#' # The following example cancels deletion of the specified KMS key.
#' svc$cancel_key_deletion(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=kms_cancel_key_deletion]{cancel_key_deletion} \tab Cancels the deletion of a KMS key\cr
#'  \link[=kms_connect_custom_key_store]{connect_custom_key_store} \tab Connects or reconnects a custom key store to its backing key store\cr
#'  \link[=kms_create_alias]{create_alias} \tab Creates a friendly name for a KMS key\cr
#'  \link[=kms_create_custom_key_store]{create_custom_key_store} \tab Creates a custom key store backed by a key store that you own and manage\cr
#'  \link[=kms_create_grant]{create_grant} \tab Adds a grant to a KMS key\cr
#'  \link[=kms_create_key]{create_key} \tab Creates a unique customer managed KMS key in your Amazon Web Services account and Region\cr
#'  \link[=kms_decrypt]{decrypt} \tab Decrypts ciphertext that was encrypted by a KMS key using any of the following operations:\cr
#'  \link[=kms_delete_alias]{delete_alias} \tab Deletes the specified alias\cr
#'  \link[=kms_delete_custom_key_store]{delete_custom_key_store} \tab Deletes a custom key store\cr
#'  \link[=kms_delete_imported_key_material]{delete_imported_key_material} \tab Deletes key material that was previously imported\cr
#'  \link[=kms_derive_shared_secret]{derive_shared_secret} \tab Derives a shared secret using a key agreement algorithm\cr
#'  \link[=kms_describe_custom_key_stores]{describe_custom_key_stores} \tab Gets information about custom key stores in the account and Region\cr
#'  \link[=kms_describe_key]{describe_key} \tab Provides detailed information about a KMS key\cr
#'  \link[=kms_disable_key]{disable_key} \tab Sets the state of a KMS key to disabled\cr
#'  \link[=kms_disable_key_rotation]{disable_key_rotation} \tab Disables automatic rotation of the key material of the specified symmetric encryption KMS key\cr
#'  \link[=kms_disconnect_custom_key_store]{disconnect_custom_key_store} \tab Disconnects the custom key store from its backing key store\cr
#'  \link[=kms_enable_key]{enable_key} \tab Sets the key state of a KMS key to enabled\cr
#'  \link[=kms_enable_key_rotation]{enable_key_rotation} \tab Enables automatic rotation of the key material of the specified symmetric encryption KMS key\cr
#'  \link[=kms_encrypt]{encrypt} \tab Encrypts plaintext of up to 4,096 bytes using a KMS key\cr
#'  \link[=kms_generate_data_key]{generate_data_key} \tab Returns a unique symmetric data key for use outside of KMS\cr
#'  \link[=kms_generate_data_key_pair]{generate_data_key_pair} \tab Returns a unique asymmetric data key pair for use outside of KMS\cr
#'  \link[=kms_generate_data_key_pair_without_plaintext]{generate_data_key_pair_without_plaintext} \tab Returns a unique asymmetric data key pair for use outside of KMS\cr
#'  \link[=kms_generate_data_key_without_plaintext]{generate_data_key_without_plaintext} \tab Returns a unique symmetric data key for use outside of KMS\cr
#'  \link[=kms_generate_mac]{generate_mac} \tab Generates a hash-based message authentication code (HMAC) for a message using an HMAC KMS key and a MAC algorithm that the key supports\cr
#'  \link[=kms_generate_random]{generate_random} \tab Returns a random byte string that is cryptographically secure\cr
#'  \link[=kms_get_key_policy]{get_key_policy} \tab Gets a key policy attached to the specified KMS key\cr
#'  \link[=kms_get_key_rotation_status]{get_key_rotation_status} \tab Provides detailed information about the rotation status for a KMS key, including whether automatic rotation of the key material is enabled for the specified KMS key, the rotation period, and the next scheduled rotation date\cr
#'  \link[=kms_get_parameters_for_import]{get_parameters_for_import} \tab Returns the public key and an import token you need to import or reimport key material for a KMS key\cr
#'  \link[=kms_get_public_key]{get_public_key} \tab Returns the public key of an asymmetric KMS key\cr
#'  \link[=kms_import_key_material]{import_key_material} \tab Imports or reimports key material into an existing KMS key that was created without key material\cr
#'  \link[=kms_list_aliases]{list_aliases} \tab Gets a list of aliases in the caller's Amazon Web Services account and region\cr
#'  \link[=kms_list_grants]{list_grants} \tab Gets a list of all grants for the specified KMS key\cr
#'  \link[=kms_list_key_policies]{list_key_policies} \tab Gets the names of the key policies that are attached to a KMS key\cr
#'  \link[=kms_list_key_rotations]{list_key_rotations} \tab Returns information about all completed key material rotations for the specified KMS key\cr
#'  \link[=kms_list_keys]{list_keys} \tab Gets a list of all KMS keys in the caller's Amazon Web Services account and Region\cr
#'  \link[=kms_list_resource_tags]{list_resource_tags} \tab Returns all tags on the specified KMS key\cr
#'  \link[=kms_list_retirable_grants]{list_retirable_grants} \tab Returns information about all grants in the Amazon Web Services account and Region that have the specified retiring principal\cr
#'  \link[=kms_put_key_policy]{put_key_policy} \tab Attaches a key policy to the specified KMS key\cr
#'  \link[=kms_re_encrypt]{re_encrypt} \tab Decrypts ciphertext and then reencrypts it entirely within KMS\cr
#'  \link[=kms_replicate_key]{replicate_key} \tab Replicates a multi-Region key into the specified Region\cr
#'  \link[=kms_retire_grant]{retire_grant} \tab Deletes a grant\cr
#'  \link[=kms_revoke_grant]{revoke_grant} \tab Deletes the specified grant\cr
#'  \link[=kms_rotate_key_on_demand]{rotate_key_on_demand} \tab Immediately initiates rotation of the key material of the specified symmetric encryption KMS key\cr
#'  \link[=kms_schedule_key_deletion]{schedule_key_deletion} \tab Schedules the deletion of a KMS key\cr
#'  \link[=kms_sign]{sign} \tab Creates a digital signature for a message or message digest by using the private key in an asymmetric signing KMS key\cr
#'  \link[=kms_tag_resource]{tag_resource} \tab Adds or edits tags on a customer managed key\cr
#'  \link[=kms_untag_resource]{untag_resource} \tab Deletes tags from a customer managed key\cr
#'  \link[=kms_update_alias]{update_alias} \tab Associates an existing KMS alias with a different KMS key\cr
#'  \link[=kms_update_custom_key_store]{update_custom_key_store} \tab Changes the properties of a custom key store\cr
#'  \link[=kms_update_key_description]{update_key_description} \tab Updates the description of a KMS key\cr
#'  \link[=kms_update_primary_region]{update_primary_region} \tab Changes the primary key of a multi-Region key\cr
#'  \link[=kms_verify]{verify} \tab Verifies a digital signature that was generated by the Sign operation\cr
#'  \link[=kms_verify_mac]{verify_mac} \tab Verifies the hash-based message authentication code (HMAC) for a specified message, HMAC KMS key, and MAC algorithm
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname kms
#' @export
kms <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .kms$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.kms <- list()

.kms$operations <- list()

.kms$metadata <- list(
  service_name = "kms",
  endpoints = list("*" = list(endpoint = "kms.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "kms.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "kms.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "kms.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "kms.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "kms.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "KMS",
  api_version = "2014-11-01",
  signing_name = "kms",
  json_version = "1.1",
  target_prefix = "TrentService"
)

.kms$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.kms$metadata, handlers, config, op)
}
