% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_operations.R
\name{accessanalyzer_get_finding_v2}
\alias{accessanalyzer_get_finding_v2}
\title{Retrieves information about the specified finding}
\usage{
accessanalyzer_get_finding_v2(
  analyzerArn,
  id,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{analyzerArn}{[required] The \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources}{ARN of the analyzer}
that generated the finding.}

\item{id}{[required] The ID of the finding to retrieve.}

\item{maxResults}{The maximum number of results to return in the response.}

\item{nextToken}{A token used for pagination of results returned.}
}
\description{
Retrieves information about the specified finding. GetFinding and GetFindingV2 both use \code{access-analyzer:GetFinding} in the \code{Action} element of an IAM policy statement. You must have permission to perform the \code{access-analyzer:GetFinding} action.

See \url{https://www.paws-r-sdk.com/docs/accessanalyzer_get_finding_v2/} for full documentation.
}
\keyword{internal}
