# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include dlm_service.R
NULL

#' Creates a policy to manage the lifecycle of the specified AWS resources
#'
#' Creates a policy to manage the lifecycle of the specified AWS resources.
#' You can create up to 100 lifecycle policies.
#'
#' @usage
#' dlm_create_lifecycle_policy(ExecutionRoleArn, Description, State,
#'   PolicyDetails)
#'
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role used to run the
#' operations specified by the lifecycle policy.
#' @param Description &#91;required&#93; A description of the lifecycle policy. The characters \\^\[0-9A-Za-z
#' \\_-\]+\\$ are supported.
#' @param State &#91;required&#93; The desired activation state of the lifecycle policy after creation.
#' @param PolicyDetails &#91;required&#93; The configuration details of the lifecycle policy.
#' 
#' Target tags cannot be re-used across lifecycle policies.
#'
#' @section Request syntax:
#' ```
#' svc$create_lifecycle_policy(
#'   ExecutionRoleArn = "string",
#'   Description = "string",
#'   State = "ENABLED"|"DISABLED",
#'   PolicyDetails = list(
#'     ResourceTypes = list(
#'       "VOLUME"
#'     ),
#'     TargetTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     Schedules = list(
#'       list(
#'         Name = "string",
#'         CopyTags = TRUE|FALSE,
#'         TagsToAdd = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         ),
#'         CreateRule = list(
#'           Interval = 123,
#'           IntervalUnit = "HOURS",
#'           Times = list(
#'             "string"
#'           )
#'         ),
#'         RetainRule = list(
#'           Count = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dlm_create_lifecycle_policy
dlm_create_lifecycle_policy <- function(ExecutionRoleArn, Description, State, PolicyDetails) {
  op <- new_operation(
    name = "CreateLifecyclePolicy",
    http_method = "POST",
    http_path = "/policies",
    paginator = list()
  )
  input <- .dlm$create_lifecycle_policy_input(ExecutionRoleArn = ExecutionRoleArn, Description = Description, State = State, PolicyDetails = PolicyDetails)
  output <- .dlm$create_lifecycle_policy_output()
  svc <- .dlm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$create_lifecycle_policy <- dlm_create_lifecycle_policy

#' Deletes the specified lifecycle policy and halts the automated
#' operations that the policy specified
#'
#' Deletes the specified lifecycle policy and halts the automated
#' operations that the policy specified.
#'
#' @usage
#' dlm_delete_lifecycle_policy(PolicyId)
#'
#' @param PolicyId &#91;required&#93; The identifier of the lifecycle policy.
#'
#' @section Request syntax:
#' ```
#' svc$delete_lifecycle_policy(
#'   PolicyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dlm_delete_lifecycle_policy
dlm_delete_lifecycle_policy <- function(PolicyId) {
  op <- new_operation(
    name = "DeleteLifecyclePolicy",
    http_method = "DELETE",
    http_path = "/policies/{policyId}/",
    paginator = list()
  )
  input <- .dlm$delete_lifecycle_policy_input(PolicyId = PolicyId)
  output <- .dlm$delete_lifecycle_policy_output()
  svc <- .dlm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$delete_lifecycle_policy <- dlm_delete_lifecycle_policy

#' Gets summary information about all or the specified data lifecycle
#' policies
#'
#' Gets summary information about all or the specified data lifecycle
#' policies.
#' 
#' To get complete information about a policy, use GetLifecyclePolicy.
#'
#' @usage
#' dlm_get_lifecycle_policies(PolicyIds, State, ResourceTypes, TargetTags,
#'   TagsToAdd)
#'
#' @param PolicyIds The identifiers of the data lifecycle policies.
#' @param State The activation state.
#' @param ResourceTypes The resource type.
#' @param TargetTags The target tag for a policy.
#' 
#' Tags are strings in the format `key=value`.
#' @param TagsToAdd The tags to add to objects created by the policy.
#' 
#' Tags are strings in the format `key=value`.
#' 
#' These user-defined tags are added in addition to the AWS-added lifecycle
#' tags.
#'
#' @section Request syntax:
#' ```
#' svc$get_lifecycle_policies(
#'   PolicyIds = list(
#'     "string"
#'   ),
#'   State = "ENABLED"|"DISABLED"|"ERROR",
#'   ResourceTypes = list(
#'     "VOLUME"
#'   ),
#'   TargetTags = list(
#'     "string"
#'   ),
#'   TagsToAdd = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dlm_get_lifecycle_policies
dlm_get_lifecycle_policies <- function(PolicyIds = NULL, State = NULL, ResourceTypes = NULL, TargetTags = NULL, TagsToAdd = NULL) {
  op <- new_operation(
    name = "GetLifecyclePolicies",
    http_method = "GET",
    http_path = "/policies",
    paginator = list()
  )
  input <- .dlm$get_lifecycle_policies_input(PolicyIds = PolicyIds, State = State, ResourceTypes = ResourceTypes, TargetTags = TargetTags, TagsToAdd = TagsToAdd)
  output <- .dlm$get_lifecycle_policies_output()
  svc <- .dlm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$get_lifecycle_policies <- dlm_get_lifecycle_policies

#' Gets detailed information about the specified lifecycle policy
#'
#' Gets detailed information about the specified lifecycle policy.
#'
#' @usage
#' dlm_get_lifecycle_policy(PolicyId)
#'
#' @param PolicyId &#91;required&#93; The identifier of the lifecycle policy.
#'
#' @section Request syntax:
#' ```
#' svc$get_lifecycle_policy(
#'   PolicyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dlm_get_lifecycle_policy
dlm_get_lifecycle_policy <- function(PolicyId) {
  op <- new_operation(
    name = "GetLifecyclePolicy",
    http_method = "GET",
    http_path = "/policies/{policyId}/",
    paginator = list()
  )
  input <- .dlm$get_lifecycle_policy_input(PolicyId = PolicyId)
  output <- .dlm$get_lifecycle_policy_output()
  svc <- .dlm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$get_lifecycle_policy <- dlm_get_lifecycle_policy

#' Updates the specified lifecycle policy
#'
#' Updates the specified lifecycle policy.
#'
#' @usage
#' dlm_update_lifecycle_policy(PolicyId, ExecutionRoleArn, State,
#'   Description, PolicyDetails)
#'
#' @param PolicyId &#91;required&#93; The identifier of the lifecycle policy.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role used to run the
#' operations specified by the lifecycle policy.
#' @param State The desired activation state of the lifecycle policy after creation.
#' @param Description A description of the lifecycle policy.
#' @param PolicyDetails The configuration of the lifecycle policy.
#' 
#' Target tags cannot be re-used across policies.
#'
#' @section Request syntax:
#' ```
#' svc$update_lifecycle_policy(
#'   PolicyId = "string",
#'   ExecutionRoleArn = "string",
#'   State = "ENABLED"|"DISABLED",
#'   Description = "string",
#'   PolicyDetails = list(
#'     ResourceTypes = list(
#'       "VOLUME"
#'     ),
#'     TargetTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     Schedules = list(
#'       list(
#'         Name = "string",
#'         CopyTags = TRUE|FALSE,
#'         TagsToAdd = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         ),
#'         CreateRule = list(
#'           Interval = 123,
#'           IntervalUnit = "HOURS",
#'           Times = list(
#'             "string"
#'           )
#'         ),
#'         RetainRule = list(
#'           Count = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname dlm_update_lifecycle_policy
dlm_update_lifecycle_policy <- function(PolicyId, ExecutionRoleArn = NULL, State = NULL, Description = NULL, PolicyDetails = NULL) {
  op <- new_operation(
    name = "UpdateLifecyclePolicy",
    http_method = "PATCH",
    http_path = "/policies/{policyId}",
    paginator = list()
  )
  input <- .dlm$update_lifecycle_policy_input(PolicyId = PolicyId, ExecutionRoleArn = ExecutionRoleArn, State = State, Description = Description, PolicyDetails = PolicyDetails)
  output <- .dlm$update_lifecycle_policy_output()
  svc <- .dlm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.dlm$operations$update_lifecycle_policy <- dlm_update_lifecycle_policy
