% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_versioning}
\alias{s3_put_bucket_versioning}
\title{Sets the versioning state of an existing bucket}
\usage{
s3_put_bucket_versioning(Bucket, ContentMD5, MFA,
  VersioningConfiguration)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{MFA}{The concatenation of the authentication device's serial number, a
space, and the value that is displayed on your authentication device.}

\item{VersioningConfiguration}{[required]}
}
\description{
Sets the versioning state of an existing bucket. To set the versioning
state, you must be the bucket owner.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_versioning(
  Bucket = "string",
  ContentMD5 = "string",
  MFA = "string",
  VersioningConfiguration = list(
    MFADelete = "Enabled"|"Disabled",
    Status = "Enabled"|"Suspended"
  )
)
}
}

\examples{
# The following example sets versioning configuration on bucket. The
# configuration enables versioning on the bucket.
\donttest{svc$put_bucket_versioning(
  Bucket = "examplebucket",
  VersioningConfiguration = list(
    MFADelete = "Disabled",
    Status = "Enabled"
  )
)}

}
\keyword{internal}
