# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include backup_service.R
NULL

#' Creates a backup plan using a backup plan name and backup rules
#'
#' @description
#' Creates a backup plan using a backup plan name and backup rules. A
#' backup plan is a document that contains information that AWS Backup uses
#' to schedule tasks that create recovery points for resources.
#' 
#' If you call `CreateBackupPlan` with a plan that already exists, an
#' `AlreadyExistsException` is returned.
#'
#' @usage
#' backup_create_backup_plan(BackupPlan, BackupPlanTags, CreatorRequestId)
#'
#' @param BackupPlan &#91;required&#93; Specifies the body of a backup plan. Includes a `BackupPlanName` and one
#' or more sets of `Rules`.
#' @param BackupPlanTags To help organize your resources, you can assign your own metadata to the
#' resources that you create. Each tag is a key-value pair. The specified
#' tags are assigned to all backups created with this plan.
#' @param CreatorRequestId Identifies the request and allows failed requests to be retried without
#' the risk of running the operation twice. If the request includes a
#' `CreatorRequestId` that matches an existing backup plan, that plan is
#' returned. This parameter is optional.
#'
#' @section Request syntax:
#' ```
#' svc$create_backup_plan(
#'   BackupPlan = list(
#'     BackupPlanName = "string",
#'     Rules = list(
#'       list(
#'         RuleName = "string",
#'         TargetBackupVaultName = "string",
#'         ScheduleExpression = "string",
#'         StartWindowMinutes = 123,
#'         CompletionWindowMinutes = 123,
#'         Lifecycle = list(
#'           MoveToColdStorageAfterDays = 123,
#'           DeleteAfterDays = 123
#'         ),
#'         RecoveryPointTags = list(
#'           "string"
#'         ),
#'         CopyActions = list(
#'           list(
#'             Lifecycle = list(
#'               MoveToColdStorageAfterDays = 123,
#'               DeleteAfterDays = 123
#'             ),
#'             DestinationBackupVaultArn = "string"
#'           )
#'         )
#'       )
#'     ),
#'     AdvancedBackupSettings = list(
#'       list(
#'         ResourceType = "string",
#'         BackupOptions = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   BackupPlanTags = list(
#'     "string"
#'   ),
#'   CreatorRequestId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_create_backup_plan
backup_create_backup_plan <- function(BackupPlan, BackupPlanTags = NULL, CreatorRequestId = NULL) {
  op <- new_operation(
    name = "CreateBackupPlan",
    http_method = "PUT",
    http_path = "/backup/plans/",
    paginator = list()
  )
  input <- .backup$create_backup_plan_input(BackupPlan = BackupPlan, BackupPlanTags = BackupPlanTags, CreatorRequestId = CreatorRequestId)
  output <- .backup$create_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_backup_plan <- backup_create_backup_plan

#' Creates a JSON document that specifies a set of resources to assign to a
#' backup plan
#'
#' @description
#' Creates a JSON document that specifies a set of resources to assign to a
#' backup plan. Resources can be included by specifying patterns for a
#' `ListOfTags` and selected `Resources`.
#' 
#' For example, consider the following patterns:
#' 
#' -   `Resources: "arn:aws:ec2:region:account-id:volume/volume-id"`
#' 
#' -   `ConditionKey:"department"`
#' 
#'     `ConditionValue:"finance"`
#' 
#'     `ConditionType:"StringEquals"`
#' 
#' -   `ConditionKey:"importance"`
#' 
#'     `ConditionValue:"critical"`
#' 
#'     `ConditionType:"StringEquals"`
#' 
#' Using these patterns would back up all Amazon Elastic Block Store
#' (Amazon EBS) volumes that are tagged as `"department=finance"`,
#' `"importance=critical"`, in addition to an EBS volume with the specified
#' volume ID.
#' 
#' Resources and conditions are additive in that all resources that match
#' the pattern are selected. This shouldn't be confused with a logical AND,
#' where all conditions must match. The matching patterns are logically put
#' together using the OR operator. In other words, all patterns that match
#' are selected for backup.
#'
#' @usage
#' backup_create_backup_selection(BackupPlanId, BackupSelection,
#'   CreatorRequestId)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies the backup plan to be associated with the selection
#' of resources.
#' @param BackupSelection &#91;required&#93; Specifies the body of a request to assign a set of resources to a backup
#' plan.
#' @param CreatorRequestId A unique string that identifies the request and allows failed requests
#' to be retried without the risk of running the operation twice.
#'
#' @section Request syntax:
#' ```
#' svc$create_backup_selection(
#'   BackupPlanId = "string",
#'   BackupSelection = list(
#'     SelectionName = "string",
#'     IamRoleArn = "string",
#'     Resources = list(
#'       "string"
#'     ),
#'     ListOfTags = list(
#'       list(
#'         ConditionType = "STRINGEQUALS",
#'         ConditionKey = "string",
#'         ConditionValue = "string"
#'       )
#'     )
#'   ),
#'   CreatorRequestId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_create_backup_selection
backup_create_backup_selection <- function(BackupPlanId, BackupSelection, CreatorRequestId = NULL) {
  op <- new_operation(
    name = "CreateBackupSelection",
    http_method = "PUT",
    http_path = "/backup/plans/{backupPlanId}/selections/",
    paginator = list()
  )
  input <- .backup$create_backup_selection_input(BackupPlanId = BackupPlanId, BackupSelection = BackupSelection, CreatorRequestId = CreatorRequestId)
  output <- .backup$create_backup_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_backup_selection <- backup_create_backup_selection

#' Creates a logical container where backups are stored
#'
#' @description
#' Creates a logical container where backups are stored. A
#' `CreateBackupVault` request includes a name, optionally one or more
#' resource tags, an encryption key, and a request ID.
#' 
#' Sensitive data, such as passport numbers, should not be included the
#' name of a backup vault.
#'
#' @usage
#' backup_create_backup_vault(BackupVaultName, BackupVaultTags,
#'   EncryptionKeyArn, CreatorRequestId)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param BackupVaultTags Metadata that you can assign to help organize the resources that you
#' create. Each tag is a key-value pair.
#' @param EncryptionKeyArn The server-side encryption key that is used to protect your backups; for
#' example,
#' `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' @param CreatorRequestId A unique string that identifies the request and allows failed requests
#' to be retried without the risk of running the operation twice.
#'
#' @section Request syntax:
#' ```
#' svc$create_backup_vault(
#'   BackupVaultName = "string",
#'   BackupVaultTags = list(
#'     "string"
#'   ),
#'   EncryptionKeyArn = "string",
#'   CreatorRequestId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_create_backup_vault
backup_create_backup_vault <- function(BackupVaultName, BackupVaultTags = NULL, EncryptionKeyArn = NULL, CreatorRequestId = NULL) {
  op <- new_operation(
    name = "CreateBackupVault",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$create_backup_vault_input(BackupVaultName = BackupVaultName, BackupVaultTags = BackupVaultTags, EncryptionKeyArn = EncryptionKeyArn, CreatorRequestId = CreatorRequestId)
  output <- .backup$create_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_backup_vault <- backup_create_backup_vault

#' Deletes a backup plan
#'
#' @description
#' Deletes a backup plan. A backup plan can only be deleted after all
#' associated selections of resources have been deleted. Deleting a backup
#' plan deletes the current version of a backup plan. Previous versions, if
#' any, will still exist.
#'
#' @usage
#' backup_delete_backup_plan(BackupPlanId)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup_plan(
#'   BackupPlanId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_plan
backup_delete_backup_plan <- function(BackupPlanId) {
  op <- new_operation(
    name = "DeleteBackupPlan",
    http_method = "DELETE",
    http_path = "/backup/plans/{backupPlanId}",
    paginator = list()
  )
  input <- .backup$delete_backup_plan_input(BackupPlanId = BackupPlanId)
  output <- .backup$delete_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_plan <- backup_delete_backup_plan

#' Deletes the resource selection associated with a backup plan that is
#' specified by the SelectionId
#'
#' @description
#' Deletes the resource selection associated with a backup plan that is
#' specified by the `SelectionId`.
#'
#' @usage
#' backup_delete_backup_selection(BackupPlanId, SelectionId)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param SelectionId &#91;required&#93; Uniquely identifies the body of a request to assign a set of resources
#' to a backup plan.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup_selection(
#'   BackupPlanId = "string",
#'   SelectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_selection
backup_delete_backup_selection <- function(BackupPlanId, SelectionId) {
  op <- new_operation(
    name = "DeleteBackupSelection",
    http_method = "DELETE",
    http_path = "/backup/plans/{backupPlanId}/selections/{selectionId}",
    paginator = list()
  )
  input <- .backup$delete_backup_selection_input(BackupPlanId = BackupPlanId, SelectionId = SelectionId)
  output <- .backup$delete_backup_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_selection <- backup_delete_backup_selection

#' Deletes the backup vault identified by its name
#'
#' @description
#' Deletes the backup vault identified by its name. A vault can be deleted
#' only if it is empty.
#'
#' @usage
#' backup_delete_backup_vault(BackupVaultName)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup_vault(
#'   BackupVaultName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault
backup_delete_backup_vault <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVault",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault <- backup_delete_backup_vault

#' Deletes the policy document that manages permissions on a backup vault
#'
#' @description
#' Deletes the policy document that manages permissions on a backup vault.
#'
#' @usage
#' backup_delete_backup_vault_access_policy(BackupVaultName)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup_vault_access_policy(
#'   BackupVaultName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault_access_policy
backup_delete_backup_vault_access_policy <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVaultAccessPolicy",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/access-policy",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_access_policy_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_access_policy_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault_access_policy <- backup_delete_backup_vault_access_policy

#' Deletes event notifications for the specified backup vault
#'
#' @description
#' Deletes event notifications for the specified backup vault.
#'
#' @usage
#' backup_delete_backup_vault_notifications(BackupVaultName)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Region where they are created. They consist of lowercase
#' letters, numbers, and hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup_vault_notifications(
#'   BackupVaultName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault_notifications
backup_delete_backup_vault_notifications <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVaultNotifications",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/notification-configuration",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_notifications_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_notifications_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault_notifications <- backup_delete_backup_vault_notifications

#' Deletes the recovery point specified by a recovery point ID
#'
#' @description
#' Deletes the recovery point specified by a recovery point ID.
#'
#' @usage
#' backup_delete_recovery_point(BackupVaultName, RecoveryPointArn)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_recovery_point(
#'   BackupVaultName = "string",
#'   RecoveryPointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_delete_recovery_point
backup_delete_recovery_point <- function(BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "DeleteRecoveryPoint",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
    paginator = list()
  )
  input <- .backup$delete_recovery_point_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$delete_recovery_point_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_recovery_point <- backup_delete_recovery_point

#' Returns backup job details for the specified BackupJobId
#'
#' @description
#' Returns backup job details for the specified `BackupJobId`.
#'
#' @usage
#' backup_describe_backup_job(BackupJobId)
#'
#' @param BackupJobId &#91;required&#93; Uniquely identifies a request to AWS Backup to back up a resource.
#'
#' @section Request syntax:
#' ```
#' svc$describe_backup_job(
#'   BackupJobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_backup_job
backup_describe_backup_job <- function(BackupJobId) {
  op <- new_operation(
    name = "DescribeBackupJob",
    http_method = "GET",
    http_path = "/backup-jobs/{backupJobId}",
    paginator = list()
  )
  input <- .backup$describe_backup_job_input(BackupJobId = BackupJobId)
  output <- .backup$describe_backup_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_backup_job <- backup_describe_backup_job

#' Returns metadata about a backup vault specified by its name
#'
#' @description
#' Returns metadata about a backup vault specified by its name.
#'
#' @usage
#' backup_describe_backup_vault(BackupVaultName)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$describe_backup_vault(
#'   BackupVaultName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_backup_vault
backup_describe_backup_vault <- function(BackupVaultName) {
  op <- new_operation(
    name = "DescribeBackupVault",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$describe_backup_vault_input(BackupVaultName = BackupVaultName)
  output <- .backup$describe_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_backup_vault <- backup_describe_backup_vault

#' Returns metadata associated with creating a copy of a resource
#'
#' @description
#' Returns metadata associated with creating a copy of a resource.
#'
#' @usage
#' backup_describe_copy_job(CopyJobId)
#'
#' @param CopyJobId &#91;required&#93; Uniquely identifies a copy job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_copy_job(
#'   CopyJobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_copy_job
backup_describe_copy_job <- function(CopyJobId) {
  op <- new_operation(
    name = "DescribeCopyJob",
    http_method = "GET",
    http_path = "/copy-jobs/{copyJobId}",
    paginator = list()
  )
  input <- .backup$describe_copy_job_input(CopyJobId = CopyJobId)
  output <- .backup$describe_copy_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_copy_job <- backup_describe_copy_job

#' The current feature settings for the AWS Account
#'
#' @description
#' The current feature settings for the AWS Account.
#'
#' @usage
#' backup_describe_global_settings()
#'
#' @section Request syntax:
#' ```
#' svc$describe_global_settings()
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_global_settings
backup_describe_global_settings <- function() {
  op <- new_operation(
    name = "DescribeGlobalSettings",
    http_method = "GET",
    http_path = "/global-settings",
    paginator = list()
  )
  input <- .backup$describe_global_settings_input()
  output <- .backup$describe_global_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_global_settings <- backup_describe_global_settings

#' Returns information about a saved resource, including the last time it
#' was backed up, its Amazon Resource Name (ARN), and the AWS service type
#' of the saved resource
#'
#' @description
#' Returns information about a saved resource, including the last time it
#' was backed up, its Amazon Resource Name (ARN), and the AWS service type
#' of the saved resource.
#'
#' @usage
#' backup_describe_protected_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a resource. The
#' format of the ARN depends on the resource type.
#'
#' @section Request syntax:
#' ```
#' svc$describe_protected_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_protected_resource
backup_describe_protected_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "DescribeProtectedResource",
    http_method = "GET",
    http_path = "/resources/{resourceArn}",
    paginator = list()
  )
  input <- .backup$describe_protected_resource_input(ResourceArn = ResourceArn)
  output <- .backup$describe_protected_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_protected_resource <- backup_describe_protected_resource

#' Returns metadata associated with a recovery point, including ID, status,
#' encryption, and lifecycle
#'
#' @description
#' Returns metadata associated with a recovery point, including ID, status,
#' encryption, and lifecycle.
#'
#' @usage
#' backup_describe_recovery_point(BackupVaultName, RecoveryPointArn)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_recovery_point(
#'   BackupVaultName = "string",
#'   RecoveryPointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_recovery_point
backup_describe_recovery_point <- function(BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "DescribeRecoveryPoint",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
    paginator = list()
  )
  input <- .backup$describe_recovery_point_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$describe_recovery_point_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_recovery_point <- backup_describe_recovery_point

#' Returns the current service opt-in settings for the Region
#'
#' @description
#' Returns the current service opt-in settings for the Region. If
#' service-opt-in is enabled for a service, AWS Backup tries to protect
#' that service's resources in this Region, when the resource is included
#' in an on-demand backup or scheduled backup plan. Otherwise, AWS Backup
#' does not try to protect that service's resources in this Region, AWS
#' Backup does not try to protect that service's resources in this Region.
#'
#' @usage
#' backup_describe_region_settings()
#'
#' @section Request syntax:
#' ```
#' svc$describe_region_settings()
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_region_settings
backup_describe_region_settings <- function() {
  op <- new_operation(
    name = "DescribeRegionSettings",
    http_method = "GET",
    http_path = "/account-settings",
    paginator = list()
  )
  input <- .backup$describe_region_settings_input()
  output <- .backup$describe_region_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_region_settings <- backup_describe_region_settings

#' Returns metadata associated with a restore job that is specified by a
#' job ID
#'
#' @description
#' Returns metadata associated with a restore job that is specified by a
#' job ID.
#'
#' @usage
#' backup_describe_restore_job(RestoreJobId)
#'
#' @param RestoreJobId &#91;required&#93; Uniquely identifies the job that restores a recovery point.
#'
#' @section Request syntax:
#' ```
#' svc$describe_restore_job(
#'   RestoreJobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_describe_restore_job
backup_describe_restore_job <- function(RestoreJobId) {
  op <- new_operation(
    name = "DescribeRestoreJob",
    http_method = "GET",
    http_path = "/restore-jobs/{restoreJobId}",
    paginator = list()
  )
  input <- .backup$describe_restore_job_input(RestoreJobId = RestoreJobId)
  output <- .backup$describe_restore_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_restore_job <- backup_describe_restore_job

#' Returns the backup plan that is specified by the plan ID as a backup
#' template
#'
#' @description
#' Returns the backup plan that is specified by the plan ID as a backup
#' template.
#'
#' @usage
#' backup_export_backup_plan_template(BackupPlanId)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#'
#' @section Request syntax:
#' ```
#' svc$export_backup_plan_template(
#'   BackupPlanId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_export_backup_plan_template
backup_export_backup_plan_template <- function(BackupPlanId) {
  op <- new_operation(
    name = "ExportBackupPlanTemplate",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/toTemplate/",
    paginator = list()
  )
  input <- .backup$export_backup_plan_template_input(BackupPlanId = BackupPlanId)
  output <- .backup$export_backup_plan_template_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$export_backup_plan_template <- backup_export_backup_plan_template

#' Returns BackupPlan details for the specified BackupPlanId
#'
#' @description
#' Returns `BackupPlan` details for the specified `BackupPlanId`. Returns
#' the body of a backup plan in JSON format, in addition to plan metadata.
#'
#' @usage
#' backup_get_backup_plan(BackupPlanId, VersionId)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param VersionId Unique, randomly generated, Unicode, UTF-8 encoded strings that are at
#' most 1,024 bytes long. Version IDs cannot be edited.
#'
#' @section Request syntax:
#' ```
#' svc$get_backup_plan(
#'   BackupPlanId = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_plan
backup_get_backup_plan <- function(BackupPlanId, VersionId = NULL) {
  op <- new_operation(
    name = "GetBackupPlan",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/",
    paginator = list()
  )
  input <- .backup$get_backup_plan_input(BackupPlanId = BackupPlanId, VersionId = VersionId)
  output <- .backup$get_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_plan <- backup_get_backup_plan

#' Returns a valid JSON document specifying a backup plan or an error
#'
#' @description
#' Returns a valid JSON document specifying a backup plan or an error.
#'
#' @usage
#' backup_get_backup_plan_from_json(BackupPlanTemplateJson)
#'
#' @param BackupPlanTemplateJson &#91;required&#93; A customer-supplied backup plan document in JSON format.
#'
#' @section Request syntax:
#' ```
#' svc$get_backup_plan_from_json(
#'   BackupPlanTemplateJson = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_plan_from_json
backup_get_backup_plan_from_json <- function(BackupPlanTemplateJson) {
  op <- new_operation(
    name = "GetBackupPlanFromJSON",
    http_method = "POST",
    http_path = "/backup/template/json/toPlan",
    paginator = list()
  )
  input <- .backup$get_backup_plan_from_json_input(BackupPlanTemplateJson = BackupPlanTemplateJson)
  output <- .backup$get_backup_plan_from_json_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_plan_from_json <- backup_get_backup_plan_from_json

#' Returns the template specified by its templateId as a backup plan
#'
#' @description
#' Returns the template specified by its `templateId` as a backup plan.
#'
#' @usage
#' backup_get_backup_plan_from_template(BackupPlanTemplateId)
#'
#' @param BackupPlanTemplateId &#91;required&#93; Uniquely identifies a stored backup plan template.
#'
#' @section Request syntax:
#' ```
#' svc$get_backup_plan_from_template(
#'   BackupPlanTemplateId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_plan_from_template
backup_get_backup_plan_from_template <- function(BackupPlanTemplateId) {
  op <- new_operation(
    name = "GetBackupPlanFromTemplate",
    http_method = "GET",
    http_path = "/backup/template/plans/{templateId}/toPlan",
    paginator = list()
  )
  input <- .backup$get_backup_plan_from_template_input(BackupPlanTemplateId = BackupPlanTemplateId)
  output <- .backup$get_backup_plan_from_template_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_plan_from_template <- backup_get_backup_plan_from_template

#' Returns selection metadata and a document in JSON format that specifies
#' a list of resources that are associated with a backup plan
#'
#' @description
#' Returns selection metadata and a document in JSON format that specifies
#' a list of resources that are associated with a backup plan.
#'
#' @usage
#' backup_get_backup_selection(BackupPlanId, SelectionId)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param SelectionId &#91;required&#93; Uniquely identifies the body of a request to assign a set of resources
#' to a backup plan.
#'
#' @section Request syntax:
#' ```
#' svc$get_backup_selection(
#'   BackupPlanId = "string",
#'   SelectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_selection
backup_get_backup_selection <- function(BackupPlanId, SelectionId) {
  op <- new_operation(
    name = "GetBackupSelection",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/selections/{selectionId}",
    paginator = list()
  )
  input <- .backup$get_backup_selection_input(BackupPlanId = BackupPlanId, SelectionId = SelectionId)
  output <- .backup$get_backup_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_selection <- backup_get_backup_selection

#' Returns the access policy document that is associated with the named
#' backup vault
#'
#' @description
#' Returns the access policy document that is associated with the named
#' backup vault.
#'
#' @usage
#' backup_get_backup_vault_access_policy(BackupVaultName)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$get_backup_vault_access_policy(
#'   BackupVaultName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_vault_access_policy
backup_get_backup_vault_access_policy <- function(BackupVaultName) {
  op <- new_operation(
    name = "GetBackupVaultAccessPolicy",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/access-policy",
    paginator = list()
  )
  input <- .backup$get_backup_vault_access_policy_input(BackupVaultName = BackupVaultName)
  output <- .backup$get_backup_vault_access_policy_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_vault_access_policy <- backup_get_backup_vault_access_policy

#' Returns event notifications for the specified backup vault
#'
#' @description
#' Returns event notifications for the specified backup vault.
#'
#' @usage
#' backup_get_backup_vault_notifications(BackupVaultName)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$get_backup_vault_notifications(
#'   BackupVaultName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_vault_notifications
backup_get_backup_vault_notifications <- function(BackupVaultName) {
  op <- new_operation(
    name = "GetBackupVaultNotifications",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/notification-configuration",
    paginator = list()
  )
  input <- .backup$get_backup_vault_notifications_input(BackupVaultName = BackupVaultName)
  output <- .backup$get_backup_vault_notifications_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_vault_notifications <- backup_get_backup_vault_notifications

#' Returns a set of metadata key-value pairs that were used to create the
#' backup
#'
#' @description
#' Returns a set of metadata key-value pairs that were used to create the
#' backup.
#'
#' @usage
#' backup_get_recovery_point_restore_metadata(BackupVaultName,
#'   RecoveryPointArn)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#'
#' @section Request syntax:
#' ```
#' svc$get_recovery_point_restore_metadata(
#'   BackupVaultName = "string",
#'   RecoveryPointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_get_recovery_point_restore_metadata
backup_get_recovery_point_restore_metadata <- function(BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "GetRecoveryPointRestoreMetadata",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/restore-metadata",
    paginator = list()
  )
  input <- .backup$get_recovery_point_restore_metadata_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$get_recovery_point_restore_metadata_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_recovery_point_restore_metadata <- backup_get_recovery_point_restore_metadata

#' Returns the AWS resource types supported by AWS Backup
#'
#' @description
#' Returns the AWS resource types supported by AWS Backup.
#'
#' @usage
#' backup_get_supported_resource_types()
#'

#'

#'
#' @keywords internal
#'
#' @rdname backup_get_supported_resource_types
backup_get_supported_resource_types <- function() {
  op <- new_operation(
    name = "GetSupportedResourceTypes",
    http_method = "GET",
    http_path = "/supported-resource-types",
    paginator = list()
  )
  input <- .backup$get_supported_resource_types_input()
  output <- .backup$get_supported_resource_types_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_supported_resource_types <- backup_get_supported_resource_types

#' Returns a list of existing backup jobs for an authenticated account
#'
#' @description
#' Returns a list of existing backup jobs for an authenticated account.
#'
#' @usage
#' backup_list_backup_jobs(NextToken, MaxResults, ByResourceArn, ByState,
#'   ByBackupVaultName, ByCreatedBefore, ByCreatedAfter, ByResourceType,
#'   ByAccountId)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByResourceArn Returns only backup jobs that match the specified resource Amazon
#' Resource Name (ARN).
#' @param ByState Returns only backup jobs that are in the specified state.
#' @param ByBackupVaultName Returns only backup jobs that will be stored in the specified backup
#' vault. Backup vaults are identified by names that are unique to the
#' account used to create them and the AWS Region where they are created.
#' They consist of lowercase letters, numbers, and hyphens.
#' @param ByCreatedBefore Returns only backup jobs that were created before the specified date.
#' @param ByCreatedAfter Returns only backup jobs that were created after the specified date.
#' @param ByResourceType Returns only backup jobs for the specified resources:
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `Storage Gateway` for AWS Storage Gateway
#' @param ByAccountId The account ID to list the jobs from. Returns only backup jobs
#' associated with the specified account ID.
#'
#' @section Request syntax:
#' ```
#' svc$list_backup_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ByResourceArn = "string",
#'   ByState = "CREATED"|"PENDING"|"RUNNING"|"ABORTING"|"ABORTED"|"COMPLETED"|"FAILED"|"EXPIRED",
#'   ByBackupVaultName = "string",
#'   ByCreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByCreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByResourceType = "string",
#'   ByAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_jobs
backup_list_backup_jobs <- function(NextToken = NULL, MaxResults = NULL, ByResourceArn = NULL, ByState = NULL, ByBackupVaultName = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByResourceType = NULL, ByAccountId = NULL) {
  op <- new_operation(
    name = "ListBackupJobs",
    http_method = "GET",
    http_path = "/backup-jobs/",
    paginator = list()
  )
  input <- .backup$list_backup_jobs_input(NextToken = NextToken, MaxResults = MaxResults, ByResourceArn = ByResourceArn, ByState = ByState, ByBackupVaultName = ByBackupVaultName, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByResourceType = ByResourceType, ByAccountId = ByAccountId)
  output <- .backup$list_backup_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_jobs <- backup_list_backup_jobs

#' Returns metadata of your saved backup plan templates, including the
#' template ID, name, and the creation and deletion dates
#'
#' @description
#' Returns metadata of your saved backup plan templates, including the
#' template ID, name, and the creation and deletion dates.
#'
#' @usage
#' backup_list_backup_plan_templates(NextToken, MaxResults)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_backup_plan_templates(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_plan_templates
backup_list_backup_plan_templates <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupPlanTemplates",
    http_method = "GET",
    http_path = "/backup/template/plans",
    paginator = list()
  )
  input <- .backup$list_backup_plan_templates_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_plan_templates_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_plan_templates <- backup_list_backup_plan_templates

#' Returns version metadata of your backup plans, including Amazon Resource
#' Names (ARNs), backup plan IDs, creation and deletion dates, plan names,
#' and version IDs
#'
#' @description
#' Returns version metadata of your backup plans, including Amazon Resource
#' Names (ARNs), backup plan IDs, creation and deletion dates, plan names,
#' and version IDs.
#'
#' @usage
#' backup_list_backup_plan_versions(BackupPlanId, NextToken, MaxResults)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_backup_plan_versions(
#'   BackupPlanId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_plan_versions
backup_list_backup_plan_versions <- function(BackupPlanId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupPlanVersions",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/versions/",
    paginator = list()
  )
  input <- .backup$list_backup_plan_versions_input(BackupPlanId = BackupPlanId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_plan_versions_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_plan_versions <- backup_list_backup_plan_versions

#' Returns a list of existing backup plans for an authenticated account
#'
#' @description
#' Returns a list of existing backup plans for an authenticated account.
#' The list is populated only if the advanced option is set for the backup
#' plan. The list contains information such as Amazon Resource Names
#' (ARNs), plan IDs, creation and deletion dates, version IDs, plan names,
#' and creator request IDs.
#'
#' @usage
#' backup_list_backup_plans(NextToken, MaxResults, IncludeDeleted)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param IncludeDeleted A Boolean value with a default value of `FALSE` that returns deleted
#' backup plans when set to `TRUE`.
#'
#' @section Request syntax:
#' ```
#' svc$list_backup_plans(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   IncludeDeleted = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_plans
backup_list_backup_plans <- function(NextToken = NULL, MaxResults = NULL, IncludeDeleted = NULL) {
  op <- new_operation(
    name = "ListBackupPlans",
    http_method = "GET",
    http_path = "/backup/plans/",
    paginator = list()
  )
  input <- .backup$list_backup_plans_input(NextToken = NextToken, MaxResults = MaxResults, IncludeDeleted = IncludeDeleted)
  output <- .backup$list_backup_plans_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_plans <- backup_list_backup_plans

#' Returns an array containing metadata of the resources associated with
#' the target backup plan
#'
#' @description
#' Returns an array containing metadata of the resources associated with
#' the target backup plan.
#'
#' @usage
#' backup_list_backup_selections(BackupPlanId, NextToken, MaxResults)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_backup_selections(
#'   BackupPlanId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_selections
backup_list_backup_selections <- function(BackupPlanId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupSelections",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/selections/",
    paginator = list()
  )
  input <- .backup$list_backup_selections_input(BackupPlanId = BackupPlanId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_selections_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_selections <- backup_list_backup_selections

#' Returns a list of recovery point storage containers along with
#' information about them
#'
#' @description
#' Returns a list of recovery point storage containers along with
#' information about them.
#'
#' @usage
#' backup_list_backup_vaults(NextToken, MaxResults)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_backup_vaults(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_vaults
backup_list_backup_vaults <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupVaults",
    http_method = "GET",
    http_path = "/backup-vaults/",
    paginator = list()
  )
  input <- .backup$list_backup_vaults_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_vaults_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_vaults <- backup_list_backup_vaults

#' Returns metadata about your copy jobs
#'
#' @description
#' Returns metadata about your copy jobs.
#'
#' @usage
#' backup_list_copy_jobs(NextToken, MaxResults, ByResourceArn, ByState,
#'   ByCreatedBefore, ByCreatedAfter, ByResourceType, ByDestinationVaultArn,
#'   ByAccountId)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return maxResults number of items, NextToken
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByResourceArn Returns only copy jobs that match the specified resource Amazon Resource
#' Name (ARN).
#' @param ByState Returns only copy jobs that are in the specified state.
#' @param ByCreatedBefore Returns only copy jobs that were created before the specified date.
#' @param ByCreatedAfter Returns only copy jobs that were created after the specified date.
#' @param ByResourceType Returns only backup jobs for the specified resources:
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `Storage Gateway` for AWS Storage Gateway
#' @param ByDestinationVaultArn An Amazon Resource Name (ARN) that uniquely identifies a source backup
#' vault to copy from; for example,
#' `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
#' @param ByAccountId The account ID to list the jobs from. Returns only copy jobs associated
#' with the specified account ID.
#'
#' @section Request syntax:
#' ```
#' svc$list_copy_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ByResourceArn = "string",
#'   ByState = "CREATED"|"RUNNING"|"COMPLETED"|"FAILED",
#'   ByCreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByCreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByResourceType = "string",
#'   ByDestinationVaultArn = "string",
#'   ByAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_copy_jobs
backup_list_copy_jobs <- function(NextToken = NULL, MaxResults = NULL, ByResourceArn = NULL, ByState = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByResourceType = NULL, ByDestinationVaultArn = NULL, ByAccountId = NULL) {
  op <- new_operation(
    name = "ListCopyJobs",
    http_method = "GET",
    http_path = "/copy-jobs/",
    paginator = list()
  )
  input <- .backup$list_copy_jobs_input(NextToken = NextToken, MaxResults = MaxResults, ByResourceArn = ByResourceArn, ByState = ByState, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByResourceType = ByResourceType, ByDestinationVaultArn = ByDestinationVaultArn, ByAccountId = ByAccountId)
  output <- .backup$list_copy_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_copy_jobs <- backup_list_copy_jobs

#' Returns an array of resources successfully backed up by AWS Backup,
#' including the time the resource was saved, an Amazon Resource Name (ARN)
#' of the resource, and a resource type
#'
#' @description
#' Returns an array of resources successfully backed up by AWS Backup,
#' including the time the resource was saved, an Amazon Resource Name (ARN)
#' of the resource, and a resource type.
#'
#' @usage
#' backup_list_protected_resources(NextToken, MaxResults)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_protected_resources(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_protected_resources
backup_list_protected_resources <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProtectedResources",
    http_method = "GET",
    http_path = "/resources/",
    paginator = list()
  )
  input <- .backup$list_protected_resources_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_protected_resources_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_protected_resources <- backup_list_protected_resources

#' Returns detailed information about the recovery points stored in a
#' backup vault
#'
#' @description
#' Returns detailed information about the recovery points stored in a
#' backup vault.
#'
#' @usage
#' backup_list_recovery_points_by_backup_vault(BackupVaultName, NextToken,
#'   MaxResults, ByResourceArn, ByResourceType, ByBackupPlanId,
#'   ByCreatedBefore, ByCreatedAfter)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByResourceArn Returns only recovery points that match the specified resource Amazon
#' Resource Name (ARN).
#' @param ByResourceType Returns only recovery points that match the specified resource type.
#' @param ByBackupPlanId Returns only recovery points that match the specified backup plan ID.
#' @param ByCreatedBefore Returns only recovery points that were created before the specified
#' timestamp.
#' @param ByCreatedAfter Returns only recovery points that were created after the specified
#' timestamp.
#'
#' @section Request syntax:
#' ```
#' svc$list_recovery_points_by_backup_vault(
#'   BackupVaultName = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ByResourceArn = "string",
#'   ByResourceType = "string",
#'   ByBackupPlanId = "string",
#'   ByCreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByCreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_recovery_points_by_backup_vault
backup_list_recovery_points_by_backup_vault <- function(BackupVaultName, NextToken = NULL, MaxResults = NULL, ByResourceArn = NULL, ByResourceType = NULL, ByBackupPlanId = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL) {
  op <- new_operation(
    name = "ListRecoveryPointsByBackupVault",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/",
    paginator = list()
  )
  input <- .backup$list_recovery_points_by_backup_vault_input(BackupVaultName = BackupVaultName, NextToken = NextToken, MaxResults = MaxResults, ByResourceArn = ByResourceArn, ByResourceType = ByResourceType, ByBackupPlanId = ByBackupPlanId, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter)
  output <- .backup$list_recovery_points_by_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_recovery_points_by_backup_vault <- backup_list_recovery_points_by_backup_vault

#' Returns detailed information about recovery points of the type specified
#' by a resource Amazon Resource Name (ARN)
#'
#' @description
#' Returns detailed information about recovery points of the type specified
#' by a resource Amazon Resource Name (ARN).
#'
#' @usage
#' backup_list_recovery_points_by_resource(ResourceArn, NextToken,
#'   MaxResults)
#'
#' @param ResourceArn &#91;required&#93; An ARN that uniquely identifies a resource. The format of the ARN
#' depends on the resource type.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_recovery_points_by_resource(
#'   ResourceArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_recovery_points_by_resource
backup_list_recovery_points_by_resource <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRecoveryPointsByResource",
    http_method = "GET",
    http_path = "/resources/{resourceArn}/recovery-points/",
    paginator = list()
  )
  input <- .backup$list_recovery_points_by_resource_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_recovery_points_by_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_recovery_points_by_resource <- backup_list_recovery_points_by_resource

#' Returns a list of jobs that AWS Backup initiated to restore a saved
#' resource, including metadata about the recovery process
#'
#' @description
#' Returns a list of jobs that AWS Backup initiated to restore a saved
#' resource, including metadata about the recovery process.
#'
#' @usage
#' backup_list_restore_jobs(NextToken, MaxResults, ByAccountId,
#'   ByCreatedBefore, ByCreatedAfter, ByStatus)
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByAccountId The account ID to list the jobs from. Returns only restore jobs
#' associated with the specified account ID.
#' @param ByCreatedBefore Returns only restore jobs that were created before the specified date.
#' @param ByCreatedAfter Returns only restore jobs that were created after the specified date.
#' @param ByStatus Returns only restore jobs associated with the specified job status.
#'
#' @section Request syntax:
#' ```
#' svc$list_restore_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ByAccountId = "string",
#'   ByCreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByCreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ByStatus = "PENDING"|"RUNNING"|"COMPLETED"|"ABORTED"|"FAILED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_restore_jobs
backup_list_restore_jobs <- function(NextToken = NULL, MaxResults = NULL, ByAccountId = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByStatus = NULL) {
  op <- new_operation(
    name = "ListRestoreJobs",
    http_method = "GET",
    http_path = "/restore-jobs/",
    paginator = list()
  )
  input <- .backup$list_restore_jobs_input(NextToken = NextToken, MaxResults = MaxResults, ByAccountId = ByAccountId, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByStatus = ByStatus)
  output <- .backup$list_restore_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_restore_jobs <- backup_list_restore_jobs

#' Returns a list of key-value pairs assigned to a target recovery point,
#' backup plan, or backup vault
#'
#' @description
#' Returns a list of key-value pairs assigned to a target recovery point,
#' backup plan, or backup vault.
#' 
#' `ListTags` are currently only supported with Amazon EFS backups.
#'
#' @usage
#' backup_list_tags(ResourceArn, NextToken, MaxResults)
#'
#' @param ResourceArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a resource. The
#' format of the ARN depends on the type of resource. Valid targets for
#' `ListTags` are recovery points, backup plans, and backup vaults.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `maxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ResourceArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_list_tags
backup_list_tags <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/tags/{resourceArn}/",
    paginator = list()
  )
  input <- .backup$list_tags_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_tags_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_tags <- backup_list_tags

#' Sets a resource-based policy that is used to manage access permissions
#' on the target backup vault
#'
#' @description
#' Sets a resource-based policy that is used to manage access permissions
#' on the target backup vault. Requires a backup vault name and an access
#' policy document in JSON format.
#'
#' @usage
#' backup_put_backup_vault_access_policy(BackupVaultName, Policy)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param Policy The backup vault access policy document in JSON format.
#'
#' @section Request syntax:
#' ```
#' svc$put_backup_vault_access_policy(
#'   BackupVaultName = "string",
#'   Policy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_put_backup_vault_access_policy
backup_put_backup_vault_access_policy <- function(BackupVaultName, Policy = NULL) {
  op <- new_operation(
    name = "PutBackupVaultAccessPolicy",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}/access-policy",
    paginator = list()
  )
  input <- .backup$put_backup_vault_access_policy_input(BackupVaultName = BackupVaultName, Policy = Policy)
  output <- .backup$put_backup_vault_access_policy_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$put_backup_vault_access_policy <- backup_put_backup_vault_access_policy

#' Turns on notifications on a backup vault for the specified topic and
#' events
#'
#' @description
#' Turns on notifications on a backup vault for the specified topic and
#' events.
#'
#' @usage
#' backup_put_backup_vault_notifications(BackupVaultName, SNSTopicArn,
#'   BackupVaultEvents)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param SNSTopicArn &#91;required&#93; The Amazon Resource Name (ARN) that specifies the topic for a backup
#' vault’s events; for example,
#' `arn:aws:sns:us-west-2:111122223333:MyVaultTopic`.
#' @param BackupVaultEvents &#91;required&#93; An array of events that indicate the status of jobs to back up resources
#' to the backup vault.
#'
#' @section Request syntax:
#' ```
#' svc$put_backup_vault_notifications(
#'   BackupVaultName = "string",
#'   SNSTopicArn = "string",
#'   BackupVaultEvents = list(
#'     "BACKUP_JOB_STARTED"|"BACKUP_JOB_COMPLETED"|"BACKUP_JOB_SUCCESSFUL"|"BACKUP_JOB_FAILED"|"BACKUP_JOB_EXPIRED"|"RESTORE_JOB_STARTED"|"RESTORE_JOB_COMPLETED"|"RESTORE_JOB_SUCCESSFUL"|"RESTORE_JOB_FAILED"|"COPY_JOB_STARTED"|"COPY_JOB_SUCCESSFUL"|"COPY_JOB_FAILED"|"RECOVERY_POINT_MODIFIED"|"BACKUP_PLAN_CREATED"|"BACKUP_PLAN_MODIFIED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_put_backup_vault_notifications
backup_put_backup_vault_notifications <- function(BackupVaultName, SNSTopicArn, BackupVaultEvents) {
  op <- new_operation(
    name = "PutBackupVaultNotifications",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}/notification-configuration",
    paginator = list()
  )
  input <- .backup$put_backup_vault_notifications_input(BackupVaultName = BackupVaultName, SNSTopicArn = SNSTopicArn, BackupVaultEvents = BackupVaultEvents)
  output <- .backup$put_backup_vault_notifications_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$put_backup_vault_notifications <- backup_put_backup_vault_notifications

#' Starts an on-demand backup job for the specified resource
#'
#' @description
#' Starts an on-demand backup job for the specified resource.
#'
#' @usage
#' backup_start_backup_job(BackupVaultName, ResourceArn, IamRoleArn,
#'   IdempotencyToken, StartWindowMinutes, CompleteWindowMinutes, Lifecycle,
#'   RecoveryPointTags, BackupOptions)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param ResourceArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a resource. The
#' format of the ARN depends on the resource type.
#' @param IamRoleArn &#91;required&#93; Specifies the IAM role ARN used to create the target recovery point; for
#' example, `arn:aws:iam::123456789012:role/S3Access`.
#' @param IdempotencyToken A customer chosen string that can be used to distinguish between calls
#' to `StartBackupJob`.
#' @param StartWindowMinutes A value in minutes after a backup is scheduled before a job will be
#' canceled if it doesn't start successfully. This value is optional.
#' @param CompleteWindowMinutes A value in minutes after a backup job is successfully started before it
#' must be completed or it will be canceled by AWS Backup. This value is
#' optional.
#' @param Lifecycle The lifecycle defines when a protected resource is transitioned to cold
#' storage and when it expires. AWS Backup will transition and expire
#' backups automatically according to the lifecycle that you define.
#' 
#' Backups transitioned to cold storage must be stored in cold storage for
#' a minimum of 90 days. Therefore, the “expire after days” setting must be
#' 90 days greater than the “transition to cold after days” setting. The
#' “transition to cold after days” setting cannot be changed after a backup
#' has been transitioned to cold.
#' @param RecoveryPointTags To help organize your resources, you can assign your own metadata to the
#' resources that you create. Each tag is a key-value pair.
#' @param BackupOptions Specifies the backup option for a selected resource. This option is only
#' available for Windows VSS backup jobs.
#' 
#' Valid values: Set to `"WindowsVSS”:“enabled"` to enable WindowsVSS
#' backup option and create a VSS Windows backup. Set to
#' “WindowsVSS”:”disabled” to create a regular backup. The WindowsVSS
#' option is not enabled by default.
#'
#' @section Request syntax:
#' ```
#' svc$start_backup_job(
#'   BackupVaultName = "string",
#'   ResourceArn = "string",
#'   IamRoleArn = "string",
#'   IdempotencyToken = "string",
#'   StartWindowMinutes = 123,
#'   CompleteWindowMinutes = 123,
#'   Lifecycle = list(
#'     MoveToColdStorageAfterDays = 123,
#'     DeleteAfterDays = 123
#'   ),
#'   RecoveryPointTags = list(
#'     "string"
#'   ),
#'   BackupOptions = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_start_backup_job
backup_start_backup_job <- function(BackupVaultName, ResourceArn, IamRoleArn, IdempotencyToken = NULL, StartWindowMinutes = NULL, CompleteWindowMinutes = NULL, Lifecycle = NULL, RecoveryPointTags = NULL, BackupOptions = NULL) {
  op <- new_operation(
    name = "StartBackupJob",
    http_method = "PUT",
    http_path = "/backup-jobs",
    paginator = list()
  )
  input <- .backup$start_backup_job_input(BackupVaultName = BackupVaultName, ResourceArn = ResourceArn, IamRoleArn = IamRoleArn, IdempotencyToken = IdempotencyToken, StartWindowMinutes = StartWindowMinutes, CompleteWindowMinutes = CompleteWindowMinutes, Lifecycle = Lifecycle, RecoveryPointTags = RecoveryPointTags, BackupOptions = BackupOptions)
  output <- .backup$start_backup_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_backup_job <- backup_start_backup_job

#' Starts a job to create a one-time copy of the specified resource
#'
#' @description
#' Starts a job to create a one-time copy of the specified resource.
#'
#' @usage
#' backup_start_copy_job(RecoveryPointArn, SourceBackupVaultName,
#'   DestinationBackupVaultArn, IamRoleArn, IdempotencyToken, Lifecycle)
#'
#' @param RecoveryPointArn &#91;required&#93; An ARN that uniquely identifies a recovery point to use for the copy
#' job; for example,
#' arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
#' @param SourceBackupVaultName &#91;required&#93; The name of a logical source container where backups are stored. Backup
#' vaults are identified by names that are unique to the account used to
#' create them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param DestinationBackupVaultArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a destination
#' backup vault to copy to; for example,
#' `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
#' @param IamRoleArn &#91;required&#93; Specifies the IAM role ARN used to copy the target recovery point; for
#' example, `arn:aws:iam::123456789012:role/S3Access`.
#' @param IdempotencyToken A customer chosen string that can be used to distinguish between calls
#' to `StartCopyJob`.
#' @param Lifecycle 
#'
#' @section Request syntax:
#' ```
#' svc$start_copy_job(
#'   RecoveryPointArn = "string",
#'   SourceBackupVaultName = "string",
#'   DestinationBackupVaultArn = "string",
#'   IamRoleArn = "string",
#'   IdempotencyToken = "string",
#'   Lifecycle = list(
#'     MoveToColdStorageAfterDays = 123,
#'     DeleteAfterDays = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_start_copy_job
backup_start_copy_job <- function(RecoveryPointArn, SourceBackupVaultName, DestinationBackupVaultArn, IamRoleArn, IdempotencyToken = NULL, Lifecycle = NULL) {
  op <- new_operation(
    name = "StartCopyJob",
    http_method = "PUT",
    http_path = "/copy-jobs",
    paginator = list()
  )
  input <- .backup$start_copy_job_input(RecoveryPointArn = RecoveryPointArn, SourceBackupVaultName = SourceBackupVaultName, DestinationBackupVaultArn = DestinationBackupVaultArn, IamRoleArn = IamRoleArn, IdempotencyToken = IdempotencyToken, Lifecycle = Lifecycle)
  output <- .backup$start_copy_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_copy_job <- backup_start_copy_job

#' Recovers the saved resource identified by an Amazon Resource Name (ARN)
#'
#' @description
#' Recovers the saved resource identified by an Amazon Resource Name (ARN).
#'
#' @usage
#' backup_start_restore_job(RecoveryPointArn, Metadata, IamRoleArn,
#'   IdempotencyToken, ResourceType)
#'
#' @param RecoveryPointArn &#91;required&#93; An ARN that uniquely identifies a recovery point; for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#' @param Metadata &#91;required&#93; A set of metadata key-value pairs. Contains information, such as a
#' resource name, required to restore a recovery point.
#' 
#' You can get configuration metadata about a resource at the time it was
#' backed up by calling `GetRecoveryPointRestoreMetadata`. However, values
#' in addition to those provided by `GetRecoveryPointRestoreMetadata` might
#' be required to restore a resource. For example, you might need to
#' provide a new resource name if the original already exists.
#' 
#' You need to specify specific metadata to restore an Amazon Elastic File
#' System (Amazon EFS) instance:
#' 
#' -   `file-system-id`: The ID of the Amazon EFS file system that is
#'     backed up by AWS Backup. Returned in
#'     `GetRecoveryPointRestoreMetadata`.
#' 
#' -   `Encrypted`: A Boolean value that, if true, specifies that the file
#'     system is encrypted. If `KmsKeyId` is specified, `Encrypted` must be
#'     set to `true`.
#' 
#' -   `KmsKeyId`: Specifies the AWS KMS key that is used to encrypt the
#'     restored file system. You can specify a key from another AWS account
#'     provided that key it is properly shared with your account via AWS
#'     KMS.
#' 
#' -   `PerformanceMode`: Specifies the throughput mode of the file system.
#' 
#' -   `CreationToken`: A user-supplied value that ensures the uniqueness
#'     (idempotency) of the request.
#' 
#' -   `newFileSystem`: A Boolean value that, if true, specifies that the
#'     recovery point is restored to a new Amazon EFS file system.
#' 
#' -   `ItemsToRestore `: A serialized list of up to five strings where
#'     each string is a file path. Use `ItemsToRestore` to restore specific
#'     files or directories rather than the entire file system. This
#'     parameter is optional.
#' @param IamRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to
#' create the target recovery point; for example,
#' `arn:aws:iam::123456789012:role/S3Access`.
#' @param IdempotencyToken A customer chosen string that can be used to distinguish between calls
#' to `StartRestoreJob`.
#' @param ResourceType Starts a job to restore a recovery point for one of the following
#' resources:
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `Storage Gateway` for AWS Storage Gateway
#'
#' @section Request syntax:
#' ```
#' svc$start_restore_job(
#'   RecoveryPointArn = "string",
#'   Metadata = list(
#'     "string"
#'   ),
#'   IamRoleArn = "string",
#'   IdempotencyToken = "string",
#'   ResourceType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_start_restore_job
backup_start_restore_job <- function(RecoveryPointArn, Metadata, IamRoleArn, IdempotencyToken = NULL, ResourceType = NULL) {
  op <- new_operation(
    name = "StartRestoreJob",
    http_method = "PUT",
    http_path = "/restore-jobs",
    paginator = list()
  )
  input <- .backup$start_restore_job_input(RecoveryPointArn = RecoveryPointArn, Metadata = Metadata, IamRoleArn = IamRoleArn, IdempotencyToken = IdempotencyToken, ResourceType = ResourceType)
  output <- .backup$start_restore_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_restore_job <- backup_start_restore_job

#' Attempts to cancel a job to create a one-time backup of a resource
#'
#' @description
#' Attempts to cancel a job to create a one-time backup of a resource.
#'
#' @usage
#' backup_stop_backup_job(BackupJobId)
#'
#' @param BackupJobId &#91;required&#93; Uniquely identifies a request to AWS Backup to back up a resource.
#'
#' @section Request syntax:
#' ```
#' svc$stop_backup_job(
#'   BackupJobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_stop_backup_job
backup_stop_backup_job <- function(BackupJobId) {
  op <- new_operation(
    name = "StopBackupJob",
    http_method = "POST",
    http_path = "/backup-jobs/{backupJobId}",
    paginator = list()
  )
  input <- .backup$stop_backup_job_input(BackupJobId = BackupJobId)
  output <- .backup$stop_backup_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$stop_backup_job <- backup_stop_backup_job

#' Assigns a set of key-value pairs to a recovery point, backup plan, or
#' backup vault identified by an Amazon Resource Name (ARN)
#'
#' @description
#' Assigns a set of key-value pairs to a recovery point, backup plan, or
#' backup vault identified by an Amazon Resource Name (ARN).
#'
#' @usage
#' backup_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; An ARN that uniquely identifies a resource. The format of the ARN
#' depends on the type of the tagged resource.
#' @param Tags &#91;required&#93; Key-value pairs that are used to help organize your resources. You can
#' assign your own metadata to the resources you create.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_tag_resource
backup_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .backup$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .backup$tag_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$tag_resource <- backup_tag_resource

#' Removes a set of key-value pairs from a recovery point, backup plan, or
#' backup vault identified by an Amazon Resource Name (ARN)
#'
#' @description
#' Removes a set of key-value pairs from a recovery point, backup plan, or
#' backup vault identified by an Amazon Resource Name (ARN)
#'
#' @usage
#' backup_untag_resource(ResourceArn, TagKeyList)
#'
#' @param ResourceArn &#91;required&#93; An ARN that uniquely identifies a resource. The format of the ARN
#' depends on the type of the tagged resource.
#' @param TagKeyList &#91;required&#93; A list of keys to identify which key-value tags to remove from a
#' resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeyList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_untag_resource
backup_untag_resource <- function(ResourceArn, TagKeyList) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untag/{resourceArn}",
    paginator = list()
  )
  input <- .backup$untag_resource_input(ResourceArn = ResourceArn, TagKeyList = TagKeyList)
  output <- .backup$untag_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$untag_resource <- backup_untag_resource

#' Updates an existing backup plan identified by its backupPlanId with the
#' input document in JSON format
#'
#' @description
#' Updates an existing backup plan identified by its `backupPlanId` with
#' the input document in JSON format. The new version is uniquely
#' identified by a `VersionId`.
#'
#' @usage
#' backup_update_backup_plan(BackupPlanId, BackupPlan)
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param BackupPlan &#91;required&#93; Specifies the body of a backup plan. Includes a `BackupPlanName` and one
#' or more sets of `Rules`.
#'
#' @section Request syntax:
#' ```
#' svc$update_backup_plan(
#'   BackupPlanId = "string",
#'   BackupPlan = list(
#'     BackupPlanName = "string",
#'     Rules = list(
#'       list(
#'         RuleName = "string",
#'         TargetBackupVaultName = "string",
#'         ScheduleExpression = "string",
#'         StartWindowMinutes = 123,
#'         CompletionWindowMinutes = 123,
#'         Lifecycle = list(
#'           MoveToColdStorageAfterDays = 123,
#'           DeleteAfterDays = 123
#'         ),
#'         RecoveryPointTags = list(
#'           "string"
#'         ),
#'         CopyActions = list(
#'           list(
#'             Lifecycle = list(
#'               MoveToColdStorageAfterDays = 123,
#'               DeleteAfterDays = 123
#'             ),
#'             DestinationBackupVaultArn = "string"
#'           )
#'         )
#'       )
#'     ),
#'     AdvancedBackupSettings = list(
#'       list(
#'         ResourceType = "string",
#'         BackupOptions = list(
#'           "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_update_backup_plan
backup_update_backup_plan <- function(BackupPlanId, BackupPlan) {
  op <- new_operation(
    name = "UpdateBackupPlan",
    http_method = "POST",
    http_path = "/backup/plans/{backupPlanId}",
    paginator = list()
  )
  input <- .backup$update_backup_plan_input(BackupPlanId = BackupPlanId, BackupPlan = BackupPlan)
  output <- .backup$update_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_backup_plan <- backup_update_backup_plan

#' Updates the current global settings for the AWS Account
#'
#' @description
#' Updates the current global settings for the AWS Account. Use the
#' `DescribeGlobalSettings` API to determine the current settings.
#'
#' @usage
#' backup_update_global_settings(GlobalSettings)
#'
#' @param GlobalSettings A list of resources along with the opt-in preferences for the account.
#'
#' @section Request syntax:
#' ```
#' svc$update_global_settings(
#'   GlobalSettings = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_update_global_settings
backup_update_global_settings <- function(GlobalSettings = NULL) {
  op <- new_operation(
    name = "UpdateGlobalSettings",
    http_method = "PUT",
    http_path = "/global-settings",
    paginator = list()
  )
  input <- .backup$update_global_settings_input(GlobalSettings = GlobalSettings)
  output <- .backup$update_global_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_global_settings <- backup_update_global_settings

#' Sets the transition lifecycle of a recovery point
#'
#' @description
#' Sets the transition lifecycle of a recovery point.
#' 
#' The lifecycle defines when a protected resource is transitioned to cold
#' storage and when it expires. AWS Backup transitions and expires backups
#' automatically according to the lifecycle that you define.
#' 
#' Backups transitioned to cold storage must be stored in cold storage for
#' a minimum of 90 days. Therefore, the “expire after days” setting must be
#' 90 days greater than the “transition to cold after days” setting. The
#' “transition to cold after days” setting cannot be changed after a backup
#' has been transitioned to cold.
#'
#' @usage
#' backup_update_recovery_point_lifecycle(BackupVaultName,
#'   RecoveryPointArn, Lifecycle)
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the AWS Region where they are created. They consist of
#' lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#' @param Lifecycle The lifecycle defines when a protected resource is transitioned to cold
#' storage and when it expires. AWS Backup transitions and expires backups
#' automatically according to the lifecycle that you define.
#' 
#' Backups transitioned to cold storage must be stored in cold storage for
#' a minimum of 90 days. Therefore, the “expire after days” setting must be
#' 90 days greater than the “transition to cold after days” setting. The
#' “transition to cold after days” setting cannot be changed after a backup
#' has been transitioned to cold.
#'
#' @section Request syntax:
#' ```
#' svc$update_recovery_point_lifecycle(
#'   BackupVaultName = "string",
#'   RecoveryPointArn = "string",
#'   Lifecycle = list(
#'     MoveToColdStorageAfterDays = 123,
#'     DeleteAfterDays = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_update_recovery_point_lifecycle
backup_update_recovery_point_lifecycle <- function(BackupVaultName, RecoveryPointArn, Lifecycle = NULL) {
  op <- new_operation(
    name = "UpdateRecoveryPointLifecycle",
    http_method = "POST",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
    paginator = list()
  )
  input <- .backup$update_recovery_point_lifecycle_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn, Lifecycle = Lifecycle)
  output <- .backup$update_recovery_point_lifecycle_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_recovery_point_lifecycle <- backup_update_recovery_point_lifecycle

#' Updates the current service opt-in settings for the Region
#'
#' @description
#' Updates the current service opt-in settings for the Region. If
#' service-opt-in is enabled for a service, AWS Backup tries to protect
#' that service's resources in this Region, when the resource is included
#' in an on-demand backup or scheduled backup plan. Otherwise, AWS Backup
#' does not try to protect that service's resources in this Region. Use the
#' `DescribeRegionSettings` API to determine the resource types that are
#' supported.
#'
#' @usage
#' backup_update_region_settings(ResourceTypeOptInPreference)
#'
#' @param ResourceTypeOptInPreference Updates the list of services along with the opt-in preferences for the
#' Region.
#'
#' @section Request syntax:
#' ```
#' svc$update_region_settings(
#'   ResourceTypeOptInPreference = list(
#'     TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname backup_update_region_settings
backup_update_region_settings <- function(ResourceTypeOptInPreference = NULL) {
  op <- new_operation(
    name = "UpdateRegionSettings",
    http_method = "PUT",
    http_path = "/account-settings",
    paginator = list()
  )
  input <- .backup$update_region_settings_input(ResourceTypeOptInPreference = ResourceTypeOptInPreference)
  output <- .backup$update_region_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_region_settings <- backup_update_region_settings
