% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_bucket_inventory_configurations}
\alias{s3_list_bucket_inventory_configurations}
\title{Returns a list of inventory configurations for the bucket}
\usage{
s3_list_bucket_inventory_configurations(Bucket, ContinuationToken,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the inventory configurations to
retrieve.}

\item{ContinuationToken}{The marker used to continue an inventory configuration listing that has
been truncated. Use the NextContinuationToken from a previously
truncated list response to continue the listing. The continuation token
is an opaque value that Amazon S3 understands.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Returns a list of inventory configurations for the bucket. You can have
up to 1,000 analytics configurations per bucket.

This operation supports list pagination and does not return more than
100 configurations at a time. Always check the \code{IsTruncated} element in
the response. If there are no more configurations to list, \code{IsTruncated}
is set to false. If there are more configurations to list, \code{IsTruncated}
is set to true, and there is a value in \code{NextContinuationToken}. You use
the \code{NextContinuationToken} value to continue the pagination of the list
by passing the value in continuation-token in the request to \code{GET} the
next page.

To use this operation, you must have permissions to perform the
\code{s3:GetInventoryConfiguration} action. The bucket owner has this
permission by default. The bucket owner can grant this permission to
others. For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

For information about the Amazon S3 inventory feature, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html}{Amazon S3 Inventory}

The following operations are related to
\code{ListBucketInventoryConfigurations}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html}{GetBucketInventoryConfiguration}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html}{DeleteBucketInventoryConfiguration}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html}{PutBucketInventoryConfiguration}
}
}
\section{Request syntax}{
\preformatted{svc$list_bucket_inventory_configurations(
  Bucket = "string",
  ContinuationToken = "string",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
