% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object_tagging}
\alias{s3_get_object_tagging}
\title{Returns the tag-set of an object}
\usage{
s3_get_object_tagging(Bucket, Key, VersionId)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{VersionId}{}
}
\description{
Returns the tag-set of an object.
}
\section{Request syntax}{
\preformatted{svc$get_object_tagging(
  Bucket = "string",
  Key = "string",
  VersionId = "string"
)
}
}

\examples{
# The following example retrieves tag set of an object. The request
# specifies object version.
\donttest{svc$get_object_tagging(
  Bucket = "examplebucket",
  Key = "exampleobject",
  VersionId = "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI"
)}

# The following example retrieves tag set of an object.
\donttest{svc$get_object_tagging(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)}

}
\keyword{internal}
