% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_local_disks}
\alias{storagegateway_list_local_disks}
\title{Returns a list of the gateway's local disks}
\usage{
storagegateway_list_local_disks(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Returns a list of the gateway's local disks. To specify which gateway
to describe, you use the Amazon Resource Name (ARN) of the gateway in
the body of the request.
}
\details{
The request returns a list of all disks, specifying which are configured
as working storage, cache storage, or stored volume or not configured at
all. The response includes a \code{DiskStatus} field. This field can have a
value of present (the disk is available to use), missing (the disk is no
longer connected to the gateway), or mismatch (the disk node is occupied
by a disk that has incorrect metadata or the disk content is corrupted).
}
\section{Request syntax}{
\preformatted{svc$list_local_disks(
  GatewayARN = "string"
)
}
}

\examples{
# The request returns a list of all disks, specifying which are configured
# as working storage, cache storage, or stored volume or not configured at
# all.
\donttest{svc$list_local_disks(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)}

}
\keyword{internal}
