% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_smb_security_strategy}
\alias{storagegateway_update_smb_security_strategy}
\title{Updates the SMB security strategy on a file gateway}
\usage{
storagegateway_update_smb_security_strategy(GatewayARN,
  SMBSecurityStrategy)
}
\arguments{
\item{GatewayARN}{[required]}

\item{SMBSecurityStrategy}{[required] Specifies the type of security strategy.

ClientSpecified: SMBv1 is enabled, SMB signing is offered but not
required, SMB encryption is offered but not required.

MandatorySigning: SMBv1 is disabled, SMB signing is required, SMB
encryption is offered but not required.

MandatoryEncryption: SMBv1 is disabled, SMB signing is offered but not
required, SMB encryption is required.}
}
\description{
Updates the SMB security strategy on a file gateway. This action is only
supported in file gateways.
}
\section{Request syntax}{
\preformatted{svc$update_smb_security_strategy(
  GatewayARN = "string",
  SMBSecurityStrategy = "ClientSpecified"|"MandatorySigning"|"MandatoryEncryption"
)
}
}

\keyword{internal}
