% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_list_tags_for_resource}
\alias{fsx_list_tags_for_resource}
\title{Lists tags for an Amazon FSx file systems and backups in the case of
Amazon FSx for Windows File Server}
\usage{
fsx_list_tags_for_resource(ResourceARN, MaxResults, NextToken)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the Amazon FSx resource that will have its tags listed.}

\item{MaxResults}{(Optional) Maximum number of tags to return in the response (integer).
This parameter value must be greater than 0. The number of items that
Amazon FSx returns is the minimum of the \code{MaxResults} parameter
specified in the request and the service\'s internal maximum number of
items per page.}

\item{NextToken}{(Optional) Opaque pagination token returned from a previous
\code{ListTagsForResource} operation (String). If a token present, the action
continues the list from where the returning call left off.}
}
\description{
Lists tags for an Amazon FSx file systems and backups in the case of
Amazon FSx for Windows File Server.
}
\details{
When retrieving all tags, you can optionally specify the \code{MaxResults}
parameter to limit the number of tags in a response. If more tags
remain, Amazon FSx returns a \code{NextToken} value in the response. In this
case, send a later request with the \code{NextToken} request parameter set to
the value of \code{NextToken} from the last response.

This action is used in an iterative process to retrieve a list of your
tags. \code{ListTagsForResource} is called first without a \code{NextToken}value.
Then the action continues to be called with the \code{NextToken} parameter
set to the value of the last \code{NextToken} value until a response has no
\code{NextToken}.

When using this action, keep the following in mind:
\itemize{
\item The implementation might return fewer than \code{MaxResults} file system
descriptions while still including a \code{NextToken} value.
\item The order of tags returned in the response of one
\code{ListTagsForResource} call and the order of tags returned across the
responses of a multi-call iteration is unspecified.
}
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
# This operation lists tags for an Amazon FSx resource.
\dontrun{svc$list_tags_for_resource(
  ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec"
)}

}
\keyword{internal}
