% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_request_payment}
\alias{s3_get_bucket_request_payment}
\title{Returns the request payment configuration of a bucket}
\usage{
s3_get_bucket_request_payment(Bucket)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the payment request
configuration}
}
\description{
Returns the request payment configuration of a bucket. To use this
version of the operation, you must be the bucket owner. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html}{Requester Pays Buckets}.
}
\details{
The following operations are related to \code{GetBucketRequestPayment}:
\itemize{
\item ListObjects
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_request_payment(
  Bucket = "string"
)
}
}

\examples{
# The following example retrieves bucket versioning configuration.
\dontrun{svc$get_bucket_request_payment(
  Bucket = "examplebucket"
)}

}
\keyword{internal}
