% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_detach_volume}
\alias{storagegateway_detach_volume}
\title{Disconnects a volume from an iSCSI connection and then detaches the
volume from the specified gateway}
\usage{
storagegateway_detach_volume(VolumeARN, ForceDetach)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the volume to detach from the gateway.}

\item{ForceDetach}{Set to \code{true} to forcibly remove the iSCSI connection of the target
volume and detach the volume. The default is \code{false}. If this value is
set to \code{false}, you must manually disconnect the iSCSI connection from
the target volume.}
}
\description{
Disconnects a volume from an iSCSI connection and then detaches the
volume from the specified gateway. Detaching and attaching a volume
enables you to recover your data from one gateway to a different gateway
without creating a snapshot. It also makes it easier to move your
volumes from an on-premises gateway to a gateway hosted on an Amazon EC2
instance. This operation is only supported in the volume gateway type.
}
\section{Request syntax}{
\preformatted{svc$detach_volume(
  VolumeARN = "string",
  ForceDetach = TRUE|FALSE
)
}
}

\keyword{internal}
