% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_objects}
\alias{s3_list_objects}
\title{Returns some or all (up to 1,000) of the objects in a bucket}
\usage{
s3_list_objects(
  Bucket,
  Delimiter = NULL,
  EncodingType = NULL,
  Marker = NULL,
  MaxKeys = NULL,
  Prefix = NULL,
  RequestPayer = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the objects.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When you use this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts access point ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{What is S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{Delimiter}{A delimiter is a character you use to group keys.}

\item{EncodingType}{}

\item{Marker}{Marker is where you want Amazon S3 to start listing from. Amazon S3
starts listing after this specified key. Marker can be any key in the
bucket.}

\item{MaxKeys}{Sets the maximum number of keys returned in the response. By default the
action returns up to 1,000 key names. The response might contain fewer
keys but will never contain more.}

\item{Prefix}{Limits the response to keys that begin with the specified prefix.}

\item{RequestPayer}{Confirms that the requester knows that she or he will be charged for the
list objects request. Bucket owners need not specify this parameter in
their requests.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be sure to design your application to parse the contents of the response and handle it appropriately.

See \url{https://www.paws-r-sdk.com/docs/s3_list_objects/} for full documentation.
}
\keyword{internal}
