% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_add_tags_to_resource}
\alias{storagegateway_add_tags_to_resource}
\title{Adds one or more tags to the specified resource}
\usage{
storagegateway_add_tags_to_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the resource you want to add tags to.}

\item{Tags}{[required] The key-value pair that represents the tag you want to add to the
resource. The value can be an empty string.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . _ : / @. The maximum length of a tag's key is 128 characters, and
the maximum length for a tag's value is 256.}
}
\description{
Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway resources:

See \url{https://www.paws-r-sdk.com/docs/storagegateway_add_tags_to_resource/} for full documentation.
}
\keyword{internal}
