% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{quicksight}
\alias{quicksight}
\title{Amazon QuickSight}
\usage{
quicksight()
}
\description{
Amazon QuickSight API Reference

Amazon QuickSight is a fully managed, serverless, cloud business
intelligence service that makes it easy to extend data and insights to
every user in your organization. This API interface reference contains
documentation for a programming interface that you can use to manage
Amazon QuickSight.
}
\section{Operations}{

\tabular{ll}{
\link[=quicksight_create_group]{create_group} \tab Creates an Amazon QuickSight group \cr
\link[=quicksight_create_group_membership]{create_group_membership} \tab Adds an Amazon QuickSight user to an Amazon QuickSight group \cr
\link[=quicksight_delete_group]{delete_group} \tab Removes a user group from Amazon QuickSight \cr
\link[=quicksight_delete_group_membership]{delete_group_membership} \tab Removes a user from a group so that the user is no longer a member of the group \cr
\link[=quicksight_delete_user]{delete_user} \tab Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management (IAM) user or role that's making the call\cr
\link[=quicksight_delete_user_by_principal_id]{delete_user_by_principal_id} \tab Deletes a user after locating the user by its principal ID \cr
\link[=quicksight_describe_group]{describe_group} \tab Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN) \cr
\link[=quicksight_describe_user]{describe_user} \tab Returns information about a user, given the user name \cr
\link[=quicksight_get_dashboard_embed_url]{get_dashboard_embed_url} \tab Generates a server-side embeddable URL and authorization code \cr
\link[=quicksight_list_group_memberships]{list_group_memberships} \tab Lists member users in a group \cr
\link[=quicksight_list_groups]{list_groups} \tab Lists all user groups in Amazon QuickSight \cr
\link[=quicksight_list_user_groups]{list_user_groups} \tab Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of \cr
\link[=quicksight_list_users]{list_users} \tab Returns a list of all of the Amazon QuickSight users belonging to this account \cr
\link[=quicksight_register_user]{register_user} \tab Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM) identity or role specified in the request\cr
\link[=quicksight_update_group]{update_group} \tab Changes a group description \cr
\link[=quicksight_update_user]{update_user} \tab Updates an Amazon QuickSight user
}
}

\examples{
\donttest{svc <- quicksight()
svc$create_group(
  Foo = 123
)}

}
