% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{kms}
\alias{kms}
\title{AWS Key Management Service}
\usage{
kms(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS Key Management Service (AWS KMS) is an encryption and key management
web service. This guide describes the AWS KMS operations that you can
call programmatically. For general information about AWS KMS, see the
\href{https://docs.aws.amazon.com/kms/latest/developerguide/}{\emph{AWS Key Management Service Developer Guide}} .

AWS provides SDKs that consist of libraries and sample code for various
programming languages and platforms (Java, Ruby, .Net, macOS, Android,
etc.). The SDKs provide a convenient way to create programmatic access
to AWS KMS and other AWS services. For example, the SDKs take care of
tasks such as signing requests (see below), managing errors, and
retrying requests automatically. For more information about the AWS
SDKs, including how to download and install them, see \href{http://aws.amazon.com/tools/}{Tools for Amazon Web Services}.

We recommend that you use the AWS SDKs to make programmatic API calls to
AWS KMS.

Clients must support TLS (Transport Layer Security) 1.0. We recommend
TLS 1.2. Clients must also support cipher suites with Perfect Forward
Secrecy (PFS) such as Ephemeral Diffie-Hellman (DHE) or Elliptic Curve
Ephemeral Diffie-Hellman (ECDHE). Most modern systems such as Java 7 and
later support these modes.

\strong{Signing Requests}

Requests must be signed by using an access key ID and a secret access
key. We strongly recommend that you \emph{do not} use your AWS account (root)
access key ID and secret key for everyday work with AWS KMS. Instead,
use the access key ID and secret access key for an IAM user. You can
also use the AWS Security Token Service to generate temporary security
credentials that you can use to sign requests.

All AWS KMS operations require \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4}.

\strong{Logging API Requests}

AWS KMS supports AWS CloudTrail, a service that logs AWS API calls and
related events for your AWS account and delivers them to an Amazon S3
bucket that you specify. By using the information collected by
CloudTrail, you can determine what requests were made to AWS KMS, who
made the request, when it was made, and so on. To learn more about
CloudTrail, including how to turn it on and find your log files, see the
\href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/}{AWS CloudTrail User Guide}.

\strong{Additional Resources}

For more information about credentials and request signing, see the
following:
\itemize{
\item \href{https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html}{AWS Security Credentials} -
This topic provides general information about the types of
credentials used for accessing AWS.
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html}{Temporary Security Credentials} -
This section of the \emph{IAM User Guide} describes how to create and use
temporary security credentials.
\item \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process} -
This set of topics walks you through the process of signing a
request using an access key ID and a secret access key.
}

\strong{Commonly Used API Operations}

Of the API operations discussed in this guide, the following will prove
the most useful for most applications. You will likely perform
operations other than these, such as creating keys and assigning
policies, by using the console.
\itemize{
\item Encrypt
\item Decrypt
\item GenerateDataKey
\item GenerateDataKeyWithoutPlaintext
}
}
\section{Service syntax}{
\preformatted{svc <- kms(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=kms_cancel_key_deletion]{cancel_key_deletion} \tab Cancels the deletion of a customer master key (CMK) \cr
\link[=kms_connect_custom_key_store]{connect_custom_key_store} \tab Connects or reconnects a custom key store to its associated AWS CloudHSM cluster \cr
\link[=kms_create_alias]{create_alias} \tab Creates a display name for a customer managed customer master key (CMK) \cr
\link[=kms_create_custom_key_store]{create_custom_key_store} \tab Creates a custom key store that is associated with an AWS CloudHSM cluster that you own and manage \cr
\link[=kms_create_grant]{create_grant} \tab Adds a grant to a customer master key (CMK) \cr
\link[=kms_create_key]{create_key} \tab Creates a unique customer managed customer master key (CMK) in your AWS account and Region \cr
\link[=kms_decrypt]{decrypt} \tab Decrypts ciphertext that was encrypted by a AWS KMS customer master key (CMK) using any of the following operations: - Encrypt - GenerateDataKey - GenerateDataKeyPair - GenerateDataKeyWithoutPlaintext - GenerateDataKeyPairWithoutPlaintext You can use this operation to decrypt ciphertext that was encrypted under a symmetric or asymmetric CMK\cr
\link[=kms_delete_alias]{delete_alias} \tab Deletes the specified alias \cr
\link[=kms_delete_custom_key_store]{delete_custom_key_store} \tab Deletes a custom key store \cr
\link[=kms_delete_imported_key_material]{delete_imported_key_material} \tab Deletes key material that you previously imported \cr
\link[=kms_describe_custom_key_stores]{describe_custom_key_stores} \tab Gets information about custom key stores in the account and region \cr
\link[=kms_describe_key]{describe_key} \tab Provides detailed information about a customer master key (CMK) \cr
\link[=kms_disable_key]{disable_key} \tab Sets the state of a customer master key (CMK) to disabled, thereby preventing its use for cryptographic operations \cr
\link[=kms_disable_key_rotation]{disable_key_rotation} \tab Disables automatic rotation of the key material for the specified symmetric customer master key (CMK) \cr
\link[=kms_disconnect_custom_key_store]{disconnect_custom_key_store} \tab Disconnects the custom key store from its associated AWS CloudHSM cluster \cr
\link[=kms_enable_key]{enable_key} \tab Sets the key state of a customer master key (CMK) to enabled \cr
\link[=kms_enable_key_rotation]{enable_key_rotation} \tab Enables automatic rotation of the key material for the specified symmetric customer master key (CMK) \cr
\link[=kms_encrypt]{encrypt} \tab Encrypts plaintext into ciphertext by using a customer master key (CMK) \cr
\link[=kms_generate_data_key]{generate_data_key} \tab Generates a unique symmetric data key \cr
\link[=kms_generate_data_key_pair]{generate_data_key_pair} \tab Generates a unique asymmetric data key pair \cr
\link[=kms_generate_data_key_pair_without_plaintext]{generate_data_key_pair_without_plaintext} \tab Generates a unique asymmetric data key pair \cr
\link[=kms_generate_data_key_without_plaintext]{generate_data_key_without_plaintext} \tab Generates a unique symmetric data key \cr
\link[=kms_generate_random]{generate_random} \tab Returns a random byte string that is cryptographically secure \cr
\link[=kms_get_key_policy]{get_key_policy} \tab Gets a key policy attached to the specified customer master key (CMK) \cr
\link[=kms_get_key_rotation_status]{get_key_rotation_status} \tab Gets a Boolean value that indicates whether automatic rotation of the key material is enabled for the specified customer master key (CMK) \cr
\link[=kms_get_parameters_for_import]{get_parameters_for_import} \tab Returns the items you need to import key material into a symmetric, customer managed customer master key (CMK) \cr
\link[=kms_get_public_key]{get_public_key} \tab Returns the public key of an asymmetric CMK \cr
\link[=kms_import_key_material]{import_key_material} \tab Imports key material into an existing symmetric AWS KMS customer master key (CMK) that was created without key material \cr
\link[=kms_list_aliases]{list_aliases} \tab Gets a list of aliases in the caller's AWS account and region \cr
\link[=kms_list_grants]{list_grants} \tab Gets a list of all grants for the specified customer master key (CMK) \cr
\link[=kms_list_key_policies]{list_key_policies} \tab Gets the names of the key policies that are attached to a customer master key (CMK) \cr
\link[=kms_list_keys]{list_keys} \tab Gets a list of all customer master keys (CMKs) in the caller's AWS account and Region \cr
\link[=kms_list_resource_tags]{list_resource_tags} \tab Returns a list of all tags for the specified customer master key (CMK) \cr
\link[=kms_list_retirable_grants]{list_retirable_grants} \tab Returns a list of all grants for which the grant's RetiringPrincipal matches the one specified \cr
\link[=kms_put_key_policy]{put_key_policy} \tab Attaches a key policy to the specified customer master key (CMK) \cr
\link[=kms_re_encrypt]{re_encrypt} \tab Decrypts ciphertext and then reencrypts it entirely within AWS KMS \cr
\link[=kms_retire_grant]{retire_grant} \tab Retires a grant \cr
\link[=kms_revoke_grant]{revoke_grant} \tab Revokes the specified grant for the specified customer master key (CMK) \cr
\link[=kms_schedule_key_deletion]{schedule_key_deletion} \tab Schedules the deletion of a customer master key (CMK) \cr
\link[=kms_sign]{sign} \tab Creates a digital signature for a message or message digest by using the private key in an asymmetric CMK \cr
\link[=kms_tag_resource]{tag_resource} \tab Adds or edits tags for a customer master key (CMK) \cr
\link[=kms_untag_resource]{untag_resource} \tab Removes the specified tags from the specified customer master key (CMK) \cr
\link[=kms_update_alias]{update_alias} \tab Associates an existing AWS KMS alias with a different customer master key (CMK) \cr
\link[=kms_update_custom_key_store]{update_custom_key_store} \tab Changes the properties of a custom key store \cr
\link[=kms_update_key_description]{update_key_description} \tab Updates the description of a customer master key (CMK) \cr
\link[=kms_verify]{verify} \tab Verifies a digital signature that was generated by the Sign operation
}
}

\examples{
\dontrun{
svc <- kms()
# The following example cancels deletion of the specified CMK.
svc$cancel_key_deletion(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
