% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{quicksight}
\alias{quicksight}
\title{Amazon QuickSight}
\usage{
quicksight(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon QuickSight API Reference

Amazon QuickSight is a fully managed, serverless business intelligence
service for the AWS Cloud that makes it easy to extend data and insights
to every user in your organization. This API reference contains
documentation for a programming interface that you can use to manage
Amazon QuickSight.
}
\section{Service syntax}{
\preformatted{svc <- quicksight(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=quicksight_cancel_ingestion]{cancel_ingestion} \tab Cancels an ongoing ingestion of data into SPICE \cr
\link[=quicksight_create_dashboard]{create_dashboard} \tab Creates a dashboard from a template \cr
\link[=quicksight_create_data_set]{create_data_set} \tab Creates a dataset \cr
\link[=quicksight_create_data_source]{create_data_source} \tab Creates a data source \cr
\link[=quicksight_create_group]{create_group} \tab Creates an Amazon QuickSight group \cr
\link[=quicksight_create_group_membership]{create_group_membership} \tab Adds an Amazon QuickSight user to an Amazon QuickSight group \cr
\link[=quicksight_create_iam_policy_assignment]{create_iam_policy_assignment} \tab Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN) \cr
\link[=quicksight_create_ingestion]{create_ingestion} \tab Creates and starts a new SPICE ingestion on a dataset Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control \cr
\link[=quicksight_create_template]{create_template} \tab Creates a template from an existing QuickSight analysis or template \cr
\link[=quicksight_create_template_alias]{create_template_alias} \tab Creates a template alias for a template \cr
\link[=quicksight_create_theme]{create_theme} \tab Creates a theme \cr
\link[=quicksight_create_theme_alias]{create_theme_alias} \tab Creates a theme alias for a theme \cr
\link[=quicksight_delete_dashboard]{delete_dashboard} \tab Deletes a dashboard \cr
\link[=quicksight_delete_data_set]{delete_data_set} \tab Deletes a dataset \cr
\link[=quicksight_delete_data_source]{delete_data_source} \tab Deletes the data source permanently \cr
\link[=quicksight_delete_group]{delete_group} \tab Removes a user group from Amazon QuickSight \cr
\link[=quicksight_delete_group_membership]{delete_group_membership} \tab Removes a user from a group so that the user is no longer a member of the group \cr
\link[=quicksight_delete_iam_policy_assignment]{delete_iam_policy_assignment} \tab Deletes an existing IAM policy assignment \cr
\link[=quicksight_delete_template]{delete_template} \tab Deletes a template \cr
\link[=quicksight_delete_template_alias]{delete_template_alias} \tab Deletes the item that the specified template alias points to \cr
\link[=quicksight_delete_theme]{delete_theme} \tab Deletes a theme \cr
\link[=quicksight_delete_theme_alias]{delete_theme_alias} \tab Deletes the version of the theme that the specified theme alias points to \cr
\link[=quicksight_delete_user]{delete_user} \tab Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management (IAM) user or role that's making the call \cr
\link[=quicksight_delete_user_by_principal_id]{delete_user_by_principal_id} \tab Deletes a user identified by its principal ID \cr
\link[=quicksight_describe_dashboard]{describe_dashboard} \tab Provides a summary for a dashboard \cr
\link[=quicksight_describe_dashboard_permissions]{describe_dashboard_permissions} \tab Describes read and write permissions for a dashboard \cr
\link[=quicksight_describe_data_set]{describe_data_set} \tab Describes a dataset \cr
\link[=quicksight_describe_data_set_permissions]{describe_data_set_permissions} \tab Describes the permissions on a dataset \cr
\link[=quicksight_describe_data_source]{describe_data_source} \tab Describes a data source \cr
\link[=quicksight_describe_data_source_permissions]{describe_data_source_permissions} \tab Describes the resource permissions for a data source \cr
\link[=quicksight_describe_group]{describe_group} \tab Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN) \cr
\link[=quicksight_describe_iam_policy_assignment]{describe_iam_policy_assignment} \tab Describes an existing IAM policy assignment, as specified by the assignment name \cr
\link[=quicksight_describe_ingestion]{describe_ingestion} \tab Describes a SPICE ingestion \cr
\link[=quicksight_describe_template]{describe_template} \tab Describes a template's metadata \cr
\link[=quicksight_describe_template_alias]{describe_template_alias} \tab Describes the template alias for a template \cr
\link[=quicksight_describe_template_permissions]{describe_template_permissions} \tab Describes read and write permissions on a template \cr
\link[=quicksight_describe_theme]{describe_theme} \tab Describes a theme \cr
\link[=quicksight_describe_theme_alias]{describe_theme_alias} \tab Describes the alias for a theme \cr
\link[=quicksight_describe_theme_permissions]{describe_theme_permissions} \tab Describes the read and write permissions for a theme \cr
\link[=quicksight_describe_user]{describe_user} \tab Returns information about a user, given the user name \cr
\link[=quicksight_get_dashboard_embed_url]{get_dashboard_embed_url} \tab Generates a URL and authorization code that you can embed in your web server code \cr
\link[=quicksight_list_dashboards]{list_dashboards} \tab Lists dashboards in an AWS account \cr
\link[=quicksight_list_dashboard_versions]{list_dashboard_versions} \tab Lists all the versions of the dashboards in the QuickSight subscription \cr
\link[=quicksight_list_data_sets]{list_data_sets} \tab Lists all of the datasets belonging to the current AWS account in an AWS Region \cr
\link[=quicksight_list_data_sources]{list_data_sources} \tab Lists data sources in current AWS Region that belong to this AWS account \cr
\link[=quicksight_list_group_memberships]{list_group_memberships} \tab Lists member users in a group \cr
\link[=quicksight_list_groups]{list_groups} \tab Lists all user groups in Amazon QuickSight \cr
\link[=quicksight_list_iam_policy_assignments]{list_iam_policy_assignments} \tab Lists IAM policy assignments in the current Amazon QuickSight account \cr
\link[=quicksight_list_iam_policy_assignments_for_user]{list_iam_policy_assignments_for_user} \tab Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to\cr
\link[=quicksight_list_ingestions]{list_ingestions} \tab Lists the history of SPICE ingestions for a dataset \cr
\link[=quicksight_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags assigned to a resource \cr
\link[=quicksight_list_template_aliases]{list_template_aliases} \tab Lists all the aliases of a template \cr
\link[=quicksight_list_templates]{list_templates} \tab Lists all the templates in the current Amazon QuickSight account \cr
\link[=quicksight_list_template_versions]{list_template_versions} \tab Lists all the versions of the templates in the current Amazon QuickSight account \cr
\link[=quicksight_list_theme_aliases]{list_theme_aliases} \tab Lists all the aliases of a theme \cr
\link[=quicksight_list_themes]{list_themes} \tab Lists all the themes in the current AWS account \cr
\link[=quicksight_list_theme_versions]{list_theme_versions} \tab Lists all the versions of the themes in the current AWS account \cr
\link[=quicksight_list_user_groups]{list_user_groups} \tab Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of \cr
\link[=quicksight_list_users]{list_users} \tab Returns a list of all of the Amazon QuickSight users belonging to this account \cr
\link[=quicksight_register_user]{register_user} \tab Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM) identity or role specified in the request \cr
\link[=quicksight_search_dashboards]{search_dashboards} \tab Searchs for dashboards that belong to a user \cr
\link[=quicksight_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified QuickSight resource \cr
\link[=quicksight_untag_resource]{untag_resource} \tab Removes a tag or tags from a resource \cr
\link[=quicksight_update_dashboard]{update_dashboard} \tab Updates a dashboard in an AWS account \cr
\link[=quicksight_update_dashboard_permissions]{update_dashboard_permissions} \tab Updates read and write permissions on a dashboard \cr
\link[=quicksight_update_dashboard_published_version]{update_dashboard_published_version} \tab Updates the published version of a dashboard \cr
\link[=quicksight_update_data_set]{update_data_set} \tab Updates a dataset \cr
\link[=quicksight_update_data_set_permissions]{update_data_set_permissions} \tab Updates the permissions on a dataset \cr
\link[=quicksight_update_data_source]{update_data_source} \tab Updates a data source \cr
\link[=quicksight_update_data_source_permissions]{update_data_source_permissions} \tab Updates the permissions to a data source \cr
\link[=quicksight_update_group]{update_group} \tab Changes a group description \cr
\link[=quicksight_update_iam_policy_assignment]{update_iam_policy_assignment} \tab Updates an existing IAM policy assignment \cr
\link[=quicksight_update_template]{update_template} \tab Updates a template from an existing Amazon QuickSight analysis or another template \cr
\link[=quicksight_update_template_alias]{update_template_alias} \tab Updates the template alias of a template \cr
\link[=quicksight_update_template_permissions]{update_template_permissions} \tab Updates the resource permissions for a template \cr
\link[=quicksight_update_theme]{update_theme} \tab Updates a theme \cr
\link[=quicksight_update_theme_alias]{update_theme_alias} \tab Updates an alias of a theme \cr
\link[=quicksight_update_theme_permissions]{update_theme_permissions} \tab Updates the resource permissions for a theme \cr
\link[=quicksight_update_user]{update_user} \tab Updates an Amazon QuickSight user
}
}

\examples{
\dontrun{
svc <- quicksight()
svc$cancel_ingestion(
  Foo = 123
)
}

}
