% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{identitystore}
\alias{identitystore}
\title{AWS SSO Identity Store}
\usage{
identitystore(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The Identity Store service used by AWS IAM Identity Center (successor to
AWS Single Sign-On) provides a single place to retrieve all of your
identities (users and groups). For more information, see the \href{https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html}{IAM Identity Center User Guide}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ <note> <p>Although AWS Single Sign-On was renamed, the <code>sso</code> and <code>identitystore</code> API namespaces will continue to retain their original name for backward compatibility purposes. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed">IAM Identity Center rename</a>.</p> </note> <p>This reference guide describes the identity store operations that you can call programatically and includes detailed information about data types and errors.</p> 
}\if{html}{\out{</div>}}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- identitystore(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:identitystore_create_group]{create_group} \tab Creates a group within the specified identity store\cr
\link[paws.security.identity:identitystore_create_group_membership]{create_group_membership} \tab Creates a relationship between a member and a group\cr
\link[paws.security.identity:identitystore_create_user]{create_user} \tab Creates a user within the specified identity store\cr
\link[paws.security.identity:identitystore_delete_group]{delete_group} \tab Delete a group within an identity store given GroupId\cr
\link[paws.security.identity:identitystore_delete_group_membership]{delete_group_membership} \tab Delete a membership within a group given MembershipId\cr
\link[paws.security.identity:identitystore_delete_user]{delete_user} \tab Deletes a user within an identity store given UserId\cr
\link[paws.security.identity:identitystore_describe_group]{describe_group} \tab Retrieves the group metadata and attributes from GroupId in an identity store\cr
\link[paws.security.identity:identitystore_describe_group_membership]{describe_group_membership} \tab Retrieves membership metadata and attributes from MembershipId in an identity store\cr
\link[paws.security.identity:identitystore_describe_user]{describe_user} \tab Retrieves the user metadata and attributes from the UserId in an identity store\cr
\link[paws.security.identity:identitystore_get_group_id]{get_group_id} \tab Retrieves GroupId in an identity store\cr
\link[paws.security.identity:identitystore_get_group_membership_id]{get_group_membership_id} \tab Retrieves the MembershipId in an identity store\cr
\link[paws.security.identity:identitystore_get_user_id]{get_user_id} \tab Retrieves the UserId in an identity store\cr
\link[paws.security.identity:identitystore_is_member_in_groups]{is_member_in_groups} \tab Checks the user's membership in all requested groups and returns if the member exists in all queried groups\cr
\link[paws.security.identity:identitystore_list_group_memberships]{list_group_memberships} \tab For the specified group in the specified identity store, returns the list of all GroupMembership objects and returns results in paginated form\cr
\link[paws.security.identity:identitystore_list_group_memberships_for_member]{list_group_memberships_for_member} \tab For the specified member in the specified identity store, returns the list of all GroupMembership objects and returns results in paginated form\cr
\link[paws.security.identity:identitystore_list_groups]{list_groups} \tab Lists all groups in the identity store\cr
\link[paws.security.identity:identitystore_list_users]{list_users} \tab Lists all users in the identity store\cr
\link[paws.security.identity:identitystore_update_group]{update_group} \tab For the specified group in the specified identity store, updates the group metadata and attributes\cr
\link[paws.security.identity:identitystore_update_user]{update_user} \tab For the specified user in the specified identity store, updates the user metadata and attributes
}
}

\examples{
\dontrun{
svc <- identitystore()
svc$create_group(
  Foo = 123
)
}

}
