% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{controltower}
\alias{controltower}
\title{AWS Control Tower}
\usage{
controltower(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
These interfaces allow you to apply the Amazon Web Services library of
pre-defined \emph{controls} to your organizational units, programmatically.
In Amazon Web Services Control Tower, the terms "control" and
"guardrail" are synonyms.

To call these APIs, you'll need to know:
\itemize{
\item the \code{controlIdentifier} for the control--or guardrail--you are
targeting.
\item the ARN associated with the target organizational unit (OU), which
we call the \code{targetIdentifier}.
\item the ARN associated with a resource that you wish to tag or untag.
}

\strong{To get the \code{controlIdentifier} for your Amazon Web Services Control
Tower control:}

The \code{controlIdentifier} is an ARN that is specified for each control.
You can view the \code{controlIdentifier} in the console on the \strong{Control
details} page, as well as in the documentation.

The \code{controlIdentifier} is unique in each Amazon Web Services Region for
each control. You can find the \code{controlIdentifier} for each Region and
control in the \href{https://docs.aws.amazon.com/controltower/latest/controlreference/control-metadata-tables.html}{Tables of control metadata}
in the \emph{Amazon Web Services Control Tower User Guide.}

A quick-reference list of control identifers for the Amazon Web Services
Control Tower legacy \emph{Strongly recommended} and \emph{Elective} controls is
given in \href{https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html}{Resource identifiers for APIs and controls}
in the \href{https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html}{Controls reference guide section}
of the \emph{Amazon Web Services Control Tower User Guide}. Remember that
\emph{Mandatory} controls cannot be added or removed.

\strong{ARN format:} \verb{arn:aws:controltower:\{REGION\}::control/\{CONTROL_NAME\}}

\strong{Example:}

\verb{arn:aws:controltower:us-west-2::control/AWS-GR_AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED}

\strong{To get the \code{targetIdentifier}:}

The \code{targetIdentifier} is the ARN for an OU.

In the Amazon Web Services Organizations console, you can find the ARN
for the OU on the \strong{Organizational unit details} page associated with
that OU.

\strong{OU ARN format:}

\verb{arn:$\{Partition\}:organizations::$\{MasterAccountId\}:ou/o-$\{OrganizationId\}/ou-$\{OrganizationalUnitId\}}

\strong{Details and examples}
\itemize{
\item \href{https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html}{Control API input and output examples with CLI}
\item \href{https://docs.aws.amazon.com/controltower/latest/controlreference/enable-controls.html}{Enable controls with CloudFormation}
\item \href{https://docs.aws.amazon.com/controltower/latest/controlreference/control-metadata-tables.html}{Control metadata tables}
\item \href{https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html}{List of identifiers for legacy controls}
\item \href{https://docs.aws.amazon.com/controltower/latest/controlreference/controls.html}{Controls reference guide}
\item \href{https://docs.aws.amazon.com/controltower/latest/controlreference/controls-reference.html}{Controls library groupings}
\item \href{https://docs.aws.amazon.com/controltower/latest/userguide/creating-resources-with-cloudformation.html}{Creating Amazon Web Services Control Tower resources with Amazon Web Services CloudFormation}
}

To view the open source resource repository on GitHub, see
\href{https://github.com/aws-cloudformation/aws-cloudformation-resource-providers-controltower}{aws-cloudformation/aws-cloudformation-resource-providers-controltower}

\strong{Recording API Requests}

Amazon Web Services Control Tower supports Amazon Web Services
CloudTrail, a service that records Amazon Web Services API calls for
your Amazon Web Services account and delivers log files to an Amazon S3
bucket. By using information collected by CloudTrail, you can determine
which requests the Amazon Web Services Control Tower service received,
who made the request and when, and so on. For more about Amazon Web
Services Control Tower and its support for CloudTrail, see \href{https://docs.aws.amazon.com/controltower/latest/userguide/logging-using-cloudtrail.html}{Logging Amazon Web Services Control Tower Actions with Amazon Web Services CloudTrail}
in the Amazon Web Services Control Tower User Guide. To learn more about
CloudTrail, including how to turn it on and find your log files, see the
Amazon Web Services CloudTrail User Guide.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- controltower(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:controltower_create_landing_zone]{create_landing_zone} \tab Creates a new landing zone\cr
\link[paws.management:controltower_delete_landing_zone]{delete_landing_zone} \tab Decommissions a landing zone\cr
\link[paws.management:controltower_disable_baseline]{disable_baseline} \tab Disable an EnabledBaseline resource on the specified Target\cr
\link[paws.management:controltower_disable_control]{disable_control} \tab This API call turns off a control\cr
\link[paws.management:controltower_enable_baseline]{enable_baseline} \tab Enable (apply) a Baseline to a Target\cr
\link[paws.management:controltower_enable_control]{enable_control} \tab This API call activates a control\cr
\link[paws.management:controltower_get_baseline]{get_baseline} \tab Retrieve details about an existing Baseline resource by specifying its identifier\cr
\link[paws.management:controltower_get_baseline_operation]{get_baseline_operation} \tab Returns the details of an asynchronous baseline operation, as initiated by any of these APIs: EnableBaseline, DisableBaseline, UpdateEnabledBaseline, ResetEnabledBaseline\cr
\link[paws.management:controltower_get_control_operation]{get_control_operation} \tab Returns the status of a particular EnableControl or DisableControl operation\cr
\link[paws.management:controltower_get_enabled_baseline]{get_enabled_baseline} \tab Retrieve details of an EnabledBaseline resource by specifying its identifier\cr
\link[paws.management:controltower_get_enabled_control]{get_enabled_control} \tab Retrieves details about an enabled control\cr
\link[paws.management:controltower_get_landing_zone]{get_landing_zone} \tab Returns details about the landing zone\cr
\link[paws.management:controltower_get_landing_zone_operation]{get_landing_zone_operation} \tab Returns the status of the specified landing zone operation\cr
\link[paws.management:controltower_list_baselines]{list_baselines} \tab Returns a summary list of all available baselines\cr
\link[paws.management:controltower_list_enabled_baselines]{list_enabled_baselines} \tab Returns a list of summaries describing EnabledBaseline resources\cr
\link[paws.management:controltower_list_enabled_controls]{list_enabled_controls} \tab Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the accounts it contains\cr
\link[paws.management:controltower_list_landing_zones]{list_landing_zones} \tab Returns the landing zone ARN for the landing zone deployed in your managed account\cr
\link[paws.management:controltower_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags associated with the resource\cr
\link[paws.management:controltower_reset_enabled_baseline]{reset_enabled_baseline} \tab Re-enables an EnabledBaseline resource\cr
\link[paws.management:controltower_reset_landing_zone]{reset_landing_zone} \tab This API call resets a landing zone\cr
\link[paws.management:controltower_tag_resource]{tag_resource} \tab Applies tags to a resource\cr
\link[paws.management:controltower_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
\link[paws.management:controltower_update_enabled_baseline]{update_enabled_baseline} \tab Updates an EnabledBaseline resource's applied parameters or version\cr
\link[paws.management:controltower_update_enabled_control]{update_enabled_control} \tab Updates the configuration of an already enabled control\cr
\link[paws.management:controltower_update_landing_zone]{update_landing_zone} \tab This API call updates the landing zone
}
}

\examples{
\dontrun{
svc <- controltower()
svc$create_landing_zone(
  Foo = 123
)
}

}
