% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_diag.r
\docType{methods}
\name{diag-constructors}
\alias{diag-constructors}
\alias{diag}
\alias{diag,vector-method}
\alias{diag,character-method}
\alias{diag,ddmatrix-method}
\alias{diag,matrix-method}
\title{Distributed Matrix Diagonals}
\usage{
\S4method{diag}{vector}(x, nrow, ncol, type = "matrix", ...,
  bldim = .pbd_env$BLDIM, ICTXT = .pbd_env$ICTXT)

\S4method{diag}{character}(x, nrow, ncol, type = "matrix", ...,
  min = 0, max = 1, mean = 0, sd = 1, rate = 1, shape,
  scale = 1, bldim = .pbd_env$BLDIM, ICTXT = .pbd_env$ICTXT)

\S4method{diag}{ddmatrix}(x)

\S4method{diag}{matrix}(x, nrow, ncol)
}
\arguments{
\item{x}{distributed matrix or a vector.}

\item{nrow, ncol}{in the case that \code{x} is a vector, these specify the
global dimension of the diagonal distributed matrix to be created.}

\item{type}{character. Options are 'matrix' or 'ddmatrix', with partial
matching.  This specifies the return type.}

\item{...}{Extra arguments}

\item{bldim}{blocking dimension.}

\item{ICTXT}{BLACS context number.}

\item{min, max}{Min and max values for random uniform generation.}

\item{mean, sd}{Mean and standard deviation for random normal generation.}

\item{rate}{Rate for random exponential generation.}

\item{shape, scale}{Shape and scale parameters for random weibull generation.}
}
\value{
If a distributed matrix is passed to \code{diag()} then it returns a
global R vector.

If a vector (numeric or character) is passed to \code{diag()} and
\code{type='ddmatrix'}, then the return is a diagonal distributed matrix.
}
\description{
Get the diagonal of a distributed matrix, or construct a distributed matrix
which is diagonal.
}
\details{
Gets the diagonal of a distributed matrix and stores it as a global R vector
owned by all processes.
}
\keyword{Extraction}
\keyword{Methods}
