% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{findModel}
\alias{findModel}
\title{Given a model name, return stanmodel object}
\usage{
findModel(model = NULL)
}
\arguments{
\item{model}{the name of a model}
}
\value{
An instance of S4 class \code{\link[rstan:stanmodel-class]{stanmodel}} that can be passed to \code{\link{pcStan}}.
}
\description{
This is a convenience function to help you look up the path to an
appropriate model for your data.
}
\details{
There are essentially three models: \sQuote{unidim}, \sQuote{covariance}, and \sQuote{factor}.
\sQuote{unidim} analyzes a single item. \sQuote{covariance} is suitable for two or more items.
Once you have vetted your items with the \sQuote{unidim} and \sQuote{covariance} models,
then you can try the \sQuote{factor} model.
For each model, there is a \sQuote{_ll} variation. This model
includes row-wise log likelihoods suitable for feeding to \pkg{loo}
for efficient approximate leave-one-out cross-validation (Vehtari, Gelman, & Gabry, 2017).

There is also a special model \sQuote{unidim_adapt}.  Except for
this model, the other models require a scaling constant.  To find
an appropriate scaling constant, we recommend fitting
\sQuote{unidim_adapt} to each item separately and then take the
median of median point estimates to set the scale. \sQuote{unidim_adapt} requires a
varCorrection constant. In general, a varCorrection of 2.0 or 3.0
should provide optimal results.

Since version 1.1.0, the factor model permits an arbitrary number
of factors and arbitrary factor-to-item paths. If you were using
the old factor model, you'll need to update your code to call
\link{prepSingleFactorModel}. Arbitrary factor model structure
should be specified using \link{prepFactorModel}.
}
\examples{
findModel()  # shows available models
findModel('unidim')
}
\references{
Vehtari A, Gelman A, Gabry J (2017). "Practical Bayesian model evaluation
using leave-one-out cross-validation and WAIC." _Statistics and Computing_,
*27*, 1413-1432. doi: 10.1007/s11222-016-9696-4
}
\seealso{
\code{\link{toLoo}}
}
