% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{prepSingleFactorModel}
\alias{prepSingleFactorModel}
\title{Specify a single factor model}
\usage{
prepSingleFactorModel(data, factorScalePrior)
}
\arguments{
\item{data}{a data list prepared for processing by Stan}

\item{factorScalePrior}{standard deviation of the normal prior for the logit transformed factor proportion}
}
\value{
a data list suitable for passing as the \code{data}
  argument to \code{\link{pcStan}} or \code{\link[rstan]{stan}}
}
\description{
Specify a single latent factor with a path to each item.
}
\examples{
dl <- prepData(phyActFlowPropensity)
dl <- prepSingleFactorModel(dl, 0.9)
str(dl)
}
\seealso{
Other factor model: \code{\link{prepFactorModel}}

Other data preppers: \code{\link{prepCleanData}},
  \code{\link{prepData}}, \code{\link{prepFactorModel}}
}
\concept{data preppers}
\concept{factor model}
