% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{inci.mat.undPE}
\alias{inci.mat.undPE}
\title{Incidence matrix for the underlying or reflexivity graph of
Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
multiple triangle case}
\usage{
inci.mat.undPE(
  Xp,
  Yp,
  r,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying or reflexivity graph of the PE-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 3D point in barycentric coordinates
which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle
(for this, argument should be set as \code{M="CC"}),
default for \eqn{M=(1,1,1)}
which is the center of mass of each triangle.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Incidence matrix for the underlying or reflexivity graph
of the PE-PCD whose vertices are the 2D data set, \code{Xp}.
PE proximity regions are constructed
with respect to the Delaunay triangles and \code{M}-vertex regions.
}
\description{
Returns the incidence matrix
for the underlying or reflexivity graph of the PE-PCD
whose vertices are the data points in \code{Xp}
in the multiple triangle case.

PE proximity regions are
defined with respect to the Delaunay triangles
based on \code{Yp} points with expansion parameter \eqn{r \ge 1} and
vertex regions in each triangle are
based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates
in the interior of each Delaunay triangle
or based on circumcenter of each Delaunay triangle
(default for \eqn{M=(1,1,1)}
which is the center of mass of the triangle).

Each Delaunay triangle is first converted to
an (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle
(this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned
by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
For the incidence matrix loops are allowed,
so the diagonal entries are all equal to 1.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on the PE-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds.ugraph})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#\donttest{
nx<-20; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)
r<-1.5

IM<-inci.mat.undPE(Xp,Yp,r,M)
IM
pcds::dom.num.greedy(IM)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.mat.undPEtri}}, \code{\link{inci.mat.undAS}},
\code{\link{inci.mat.undCS}}, and \code{\link[pcds]{inci.matPE}}
}
\author{
Elvan Ceyhan
}
