% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam2PEbastri}
\alias{Gam2PEbastri}
\title{The indicator for two points being a dominating set for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - basic triangle case}
\usage{
Gam2PEbastri(
  pt1,
  pt2,
  Dt,
  r,
  c1,
  c2,
  M = c(1, 1, 1),
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{pt1, pt2}{Two 2D points to be tested for constituting a dominating set of the PE-PCD}

\item{Dt}{A set of 2D points which constitutes the vertices of the PE-PCD}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{c1, c2}{Positive real numbers which constitute the vertex of the basic triangle
adjacent to the shorter edges; \code{c1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the basic triangle \eqn{T_b} or the circumcenter of \eqn{T_b};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \eqn{T_b}}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{pt1} and \code{pt2}, respectively.
They take the vertex labels as 1,2,3 as in the row order of the vertices in \eqn{T_b} (default is \code{NULL} for both)}

\item{ch.data.pnts}{A logical argument for checking whether points \code{pt1} and \code{pt2} are data points in \code{Dt} or not
(default is \code{FALSE})}
}
\value{
I(\{\code{pt1,pt2}\} is a dominating set of the PE-PCD) where the vertices of the PE-PCD are the 2D data set \code{Dt}),
that is, returns 1 if \{\code{pt1,pt2}\} is a dominating set of PE-PCD, returns 0 otherwise
}
\description{
Returns I(\{\code{pt1,pt2}\} is a dominating set of the PE-PCD) where the vertices of the PE-PCD are the 2D data set \code{Dt} in the basic triangle
\eqn{T_b=T((0,0),(1,0),(c_1,c_2))}, that is, returns 1 if \{\code{pt1,pt2}\} is a dominating set of PE-PCD,
returns 0 otherwise.

PE proximity regions are defined with respect to \eqn{T_b}.
In the basic triangle, \eqn{T_b}, \code{c1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence basic triangle is useful for simulation
studies under the uniformness hypothesis.

Vertex regions are based on center \eqn{M=(m_1,m_2)} in Cartesian
coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of a basic triangle \eqn{T_b};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \eqn{T_b}.
Point, \code{pt1}, is in the vertex region of vertex \code{rv1} (default is \code{NULL});
and point, \code{pt2}, is in the vertex region of vertex \code{rv2} (default is \code{NULL}); vertices are labeled as 1,2,3
in the order they are stacked row-wise.

\code{ch.data.pnts} is for checking whether points \code{pt1} and \code{pt2} are both data points in \code{Dt} or not (default is \code{FALSE}),
so by default this function checks whether the points \code{pt1} and \code{pt2} would constitute a dominating set
if they both were actually in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-10  #try also n<-20

set.seed(1)
dat<-runif.bastri(n,c1,c2)$g

M<-as.numeric(runif.bastri(1,c1,c2)$g)  #try also M<-c(.6,.3)

r<-2

Gam2PEbastri(dat[1,],dat[2,],dat,r,c1,c2,M)
Gam2PEbastri(c(1,1),dat[2,],dat,r,c1,c2,M)

Gam2PEbastri(c(1,2),dat[2,],dat,r,c1,c2,M)

Gam2PEbastri(c(1,2),c(1,3),rbind(c(1,2),c(1,3)),r,c1,c2,M)
Gam2PEbastri(c(1,2),c(1,3),rbind(c(1,2),c(1,3)),r,c1,c2,M,ch.data.pnts = TRUE)

ind.gam2<-vector()
for (i in 1:(n-1))
  for (j in (i+1):n)
  {if (Gam2PEbastri(dat[i,],dat[j,],dat,r,c1,c2,M)==1)
    ind.gam2<-rbind(ind.gam2,c(i,j))}
ind.gam2

#or try
rv1<-rv.bastri.cent(dat[1,],c1,c2,M)$rv;
rv2<-rv.bastri.cent(dat[2,],c1,c2,M)$rv;
Gam2PEbastri(dat[1,],dat[2,],dat,r,c1,c2,M,rv1,rv2)

#or try
rv1<-rv.bastri.cent(dat[1,],c1,c2,M)$rv;
Gam2PEbastri(dat[1,],dat[2,],dat,r,c1,c2,M,rv1)

#or try
rv2<-rv.bastri.cent(dat[2,],c1,c2,M)$rv;
Gam2PEbastri(dat[1,],dat[2,],dat,r,c1,c2,M,rv2=rv2)

P1<-c(.4,.2)
P2<-c(.6,.2)
Gam2PEbastri(P1,P2,dat,r,c1,c2,M)

Gam2PEbastri(P1,P2,rbind(dat,dat),r,c1,c2,M)

dat.fr<-data.frame(a=dat)
Gam2PEbastri(P1,P2,dat.fr,r,c1,c2,M)

\dontrun{
Gam2PEbastri(c(1,2),dat[2,],dat,r,c1,c2,M,ch.data.pnts = TRUE)
#gives an error message since not both points are data points in Dt
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam2PEtri}}, \code{\link{Gam2ASbastri}}, and \code{\link{Gam2AStri}}
}
