% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{cl2eTbVRcent}
\alias{cl2eTbVRcent}
\title{An object of class "Extrema":

The closest points among a data set in the vertex regions to the corresponding edges in a basic triangle}
\usage{
cl2eTbVRcent(Dt, c1, c2, M)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points}

\item{c1, c2}{Positive real numbers which constitute the vertex of the basic triangle
adjacent to the shorter edges; \code{c1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the basic triangle \eqn{T_b} or the circumcenter of \eqn{T_b}}
}
\value{
A list with the elements
\item{txt1}{Vertex labels are A=1, B=2, and C=3 (corresponds to row number in Extrema Points).}
\item{txt2}{A short description of the distances as "Distances to Edges in the Respective M-Vertex Regions".}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The "main" title for the plot of the exrema}
\item{Ext}{The extrema points, here, closest points to edges in the corresponding vertex region.}
\item{X}{The input data, \code{Dt}, can be a matrix or data frame}
\item{num.points}{The number of data points, i.e., size of \code{Dt}}
\item{supp}{Support of the data points, here, it is \eqn{T_b}.}
\item{cent}{The center point used for construction of vertex regions}
\item{ncent}{Name of the center, \code{cent}, it is "M" or "CC" for this function}
\item{regions}{Vertex regions inside the triangle, \eqn{T_b}.}
\item{region.names}{Names of the vertex regions as "vr=1","vr=2","vr=3"}
\item{region.centers}{Centers of mass of the vertex regions inside \eqn{T_b}.}
\item{dist2ref}{Distances of closest points in the vertex regions to corresponding edges.}
}
\description{
Returns the closest data points among the data set, \code{Dt}, to edge \eqn{i} in \code{M}-vertex region \eqn{i} for \eqn{i=1,2,3}
in the basic triangle \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2))} where \code{c1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.
Vertex labels are A=1, B=2, and C=3, and corresponding edge labels are BC=1, AC=2, and AB=3.

Vertex regions are based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the basic triangle \eqn{T_b}
or based on the circumcenter of \eqn{T_b}.

Any given triangle can be mapped to the basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence basic triangle is useful for simulation
studies under the uniformness hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\donttest{
c1<-.4;  c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);

set.seed(1)
n<-20
dat<-runif.bastri(n,c1,c2)$g

M<-as.numeric(runif.bastri(1,c1,c2)$g)  #try also M<-c(.6,.3)

Ext<-cl2eTbVRcent(dat,c1,c2,M)
Ext
summary(Ext)
plot(Ext)

cl2eTbVRcent(dat[1,],c1,c2,M)
cl2eTbVRcent(c(1,2),c1,c2,M)

cl2e<-cl2eTbVRcent(dat,c1,c2,M)
cl2e

Ds<-cp2e.bastri(c1,c2,M)

Xlim<-range(Tb[,1],dat[,1])
Ylim<-range(Tb[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tb,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
points(dat,pch=1,col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(cl2e$Ext,pch=3,col=2)

xc<-Tb[,1]+c(-.02,.02,0.02)
yc<-Tb[,2]+c(.02,.02,.02)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(-.02,.04,-.03,0)
yc<-txt[,2]+c(-.02,.02,.02,-.03)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)

cl2eTbVRcent(dat,c1,c2,M)

dat.fr<-data.frame(a=dat)
cl2eTbVRcent(dat.fr,c1,c2,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cl2eVRCM}}, \code{\link{cl2eVRcent}}, and \code{\link{cl2edgesTe}}
}
