% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{plot.Extrema}
\alias{plot.Extrema}
\title{Plot an \code{Extrema} object}
\usage{
\method{plot}{Extrema}(x, asp = NA, xlab = " ", ylab = " ", zlab = "", ...)
}
\arguments{
\item{x}{Object of class \code{Extrema}}

\item{asp}{A numeric value, giving the aspect ratio for y axis to x-axis y/x for the 2D case,
it is redundant in the 3D case (default is \code{NA}),
see the official help for \code{asp} by typing "? asp"}

\item{xlab, ylab, zlab}{Titles for the x and y axes in the 2D case, and x, y, and z axes in the 3D case,
respectively (default is "" for all.)}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the data points and extrema among these points together with the reference object
(e.g., boundary of the support region)
}
\examples{
n<-20
dat<-runifTe(n)$gen.points
Ext<-cl2edgesTe(dat)
Ext
plot(Ext,asp=1)

}
\seealso{
\code{\link{print.Extrema}}, \code{\link{summary.Extrema}}, and \code{\link{print.summary.Extrema}}
}
