% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{summary.Uniform}
\alias{summary.Uniform}
\title{Return a summary of a \code{Uniform} object}
\usage{
\method{summary}{Uniform}(object, ...)
}
\arguments{
\item{object}{Object of class \code{Uniform}.}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the object of class '\code{Uniform}', the \code{type} of the pattern (i.e. the description
of the uniform distribution), study window, vertices of the support of the Uniform distribution,
some sample points generated from the uniform distribution, and the number of points (i.e., number of generated
points and the number of vertices of the support of the uniform distribution.)
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object}, the \code{type} of the pattern (i.e. the description
of the uniform distribution), study window, vertices of the support of the Uniform distribution,
some sample points generated from the uniform distribution, and the number of points (i.e., number of generated
points and the number of vertices of the support of the uniform distribution.)
}
\examples{
n<-10 #try also 100
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C)

Xdt<-runif.tri(n,Tr)
Xdt
summary(Xdt)

}
\seealso{
\code{\link{print.Uniform}}, \code{\link{print.summary.Uniform}}, and \code{\link{plot.Uniform}}
}
