% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IndNPEbas.tri}
\alias{IndNPEbas.tri}
\title{The indicator for the presence of an arc from a point to another for Proportional Edge Proximity Catch
Digraphs (PE-PCDs) - standard basic triangle case}
\usage{
IndNPEbas.tri(p1, p2, r, c1, c2, M = c(1, 1, 1), rv = NULL)
}
\arguments{
\item{p1}{A 2D point whose PE proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the PE proximity region of
\code{p1} or not.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{c1, c2}{Positive real numbers which constitute the vertex of the standard basic triangle
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard basic triangle or circumcenter of \eqn{T_b}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_b}.}

\item{rv}{The index of the vertex region in \eqn{T_b} containing the point, either \code{1,2,3} or \code{NULL}
(default is \code{NULL}).}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise, where \eqn{N_{PE}(x,r)} is the PE proximity region for point \eqn{x} with expansion parameter \eqn{r \ge 1}.

PE proximity region is defined with respect to the standard basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Vertex regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in
barycentric coordinates in the interior of the standard basic triangle \eqn{T_b} or based on circumcenter of \eqn{T_b};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_b}.
\code{rv} is the index of the vertex region \code{p1} resides, with default=\code{NULL}.

If \code{p1} and \code{p2} are distinct and either of them are outside \eqn{T_b}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions (i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle. Hence standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);

M<-as.numeric(runif.bas.tri(1,c1,c2)$g)

r<-2

P1<-as.numeric(runif.bas.tri(1,c1,c2)$g)
P2<-as.numeric(runif.bas.tri(1,c1,c2)$g)
IndNPEbas.tri(P1,P2,r,c1,c2,M)

P1<-c(.4,.2)
P2<-c(.5,.26)
IndNPEbas.tri(P1,P2,r,c1,c2,M)
IndNPEbas.tri(P2,P1,r,c1,c2,M)

#or try
Rv<-rv.bas.tri.cent(P1,c1,c2,M)$rv
IndNPEbas.tri(P1,P2,r,c1,c2,M,Rv)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNPEtri}} and \code{\link{IndNPETe}}
}
\author{
Elvan Ceyhan
}
