% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{PEdomTri}
\alias{PEdomTri}
\title{The domination number of Proportional Edge Proximity Catch Digraph (PE-PCD) - one triangle case}
\usage{
PEdomTri(Xp, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the digraph.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{(1,1,1)} i.e., the center of mass.}
}
\value{
A \code{list} with two elements
\item{dom.num}{Domination number of PE-PCD with vertex set = \code{Xp} and expansion parameter \eqn{r \ge 1} and center \code{M}}
\item{mds}{A minimum dominating set of PE-PCD with vertex set = \code{Xp} and expansion parameter \eqn{r \ge 1} and center \code{M}}
\item{ind.mds}{Indices of the minimum dominating set \code{mds}}
}
\description{
Returns the domination number of PE-PCD whose vertices are the data points in \code{Xp}.

PE proximity region is defined with respect to the triangle \code{tri} with expansion parameter \eqn{r \ge 1} and
vertex regions are constructed with center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri} or the circumcenter of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2)
Tr<-rbind(A,B,C)
n<-10  #try also n<-20
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1,1,1)

r<-1.4

PEdomTri(Xp,Tr,r,M)
IM<-IncMatPEtri(Xp,Tr,r,M)
dom.greedy #try also dom.exact(IM)

gr.gam<-dom.greedy(IM)
gr.gam
Xp[gr.gam$i,]

PEdomTri(Xp,Tr,r,M=c(.4,.4))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEdom.nd}}, \code{\link{PEdom}} and \code{\link{PEdom1D}}
}
\author{
Elvan Ceyhan
}
