% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{plotPEregs1D}
\alias{plotPEregs1D}
\title{The plot of the Proportional Edge (PE) Proximity Regions (vertices jittered along \eqn{y}-coordinate)
- multiple interval case}
\usage{
plotPEregs1D(
  Xp,
  Yp,
  r,
  c = 0.5,
  Jit = 0.1,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  centers = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 1D points for which PE proximity regions are plotted.}

\item{Yp}{A set of 1D points which constitute the end points of the intervals which
partition the real line.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{Jit}{A positive real number that determines the amount of jitter along the \eqn{y}-axis, default=\code{0.1} and
\code{Xp} points are jittered according to \eqn{U(-Jit,Jit)} distribution along the \eqn{y}-axis where \code{Jit} equals to the range of \code{Xp} and \code{Yp} and the
proximity regions (intervals) multiplied by \code{Jit}).}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{centers}{A logical argument, if \code{TRUE}, plot includes the centers of the intervals
as vertical lines in the plot, else centers of the intervals are not plotted (default is \code{FALSE}).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the PE proximity regions for 1D points located in the middle or end intervals
based on \code{Yp} points
}
\description{
Plots the points in and outside of the intervals based on \code{Yp} points and also the PE proximity regions
(i.e., intervals). PE proximity region is constructed with expansion parameter \eqn{r \ge 1} and
centrality parameter \eqn{c \in (0,1)}.

For better visualization, a uniform jitter from \eqn{U(-Jit,Jit)}
(default is \eqn{Jit=.1}) times range of \code{Xp} and \code{Yp} and the proximity regions (intervals)) is added to the
\eqn{y}-direction.

\code{centers} is a logical argument, if \code{TRUE},
plot includes the centers of the intervals as vertical lines in the plot,
else centers of the intervals are not plotted.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
r<-2
c<-.4
a<-0; b<-10; int<-c(a,b);

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

plotPEregs1D(Xp,Yp,r,c,xlab="x",ylab="")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEregs1D}}, \code{\link{plotCSregs.int}}, and \code{\link{plotCSregs1D}}
}
\author{
Elvan Ceyhan
}
