% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{runif.basic.tri}
\alias{runif.basic.tri}
\title{Generation of Uniform Points in the standard basic triangle}
\usage{
runif.basic.tri(n, c1, c2)
}
\arguments{
\item{n}{A positive integer representing the number of uniform points
to be generated in the standard basic triangle.}

\item{c1, c2}{Positive real numbers representing the top vertex
in standard basic triangle
\eqn{T_b=T((0,0),(1,0),(c_1,c_2))},
\eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and
\eqn{(1-c_1)^2+c_2^2 \le 1}.}
}
\value{
A \code{list} with the elements
\item{type}{The type of the pattern from which points are to be generated}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{tess.points}{The vertices of the support
of the uniformly generated points,
it is the standard basic triangle \eqn{T_b} for this function}
\item{gen.points}{The output set of generated points uniformly
in the standard basic triangle}
\item{out.region}{The outer region which contains the support region,
\code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern
from which points are to be generated}
\item{num.points}{The \code{vector} of two numbers,
which are the number of generated points and the number
of vertices of the support points (here it is 3).}
\item{txt4pnts}{Description of the two numbers in \code{num.points}.}
\item{xlimit,ylimit}{The ranges of the \eqn{x}-
and \eqn{y}-coordinates of the support, Tb}
}
\description{
An object of class \code{"Uniform"}.
Generates \code{n} points uniformly
in the standard basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0}
 and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the basic
triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle
(\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:arc-density-PE;textual}{pcds}).
Hence, standard basic triangle is useful for simulation studies
under the uniformity hypothesis.
}
\examples{
\dontrun{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);
n<-100

set.seed(1)
runif.basic.tri(1,c1,c2)
Xdt<-runif.basic.tri(n,c1,c2)
Xdt
summary(Xdt)
plot(Xdt)

Xp<-runif.basic.tri(n,c1,c2)$g

Xlim<-range(Tb[,1])
Ylim<-range(Tb[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tb,xlab="",ylab="",xlim=Xlim+xd*c(-.01,.01),
ylim=Ylim+yd*c(-.01,.01),type="n")
polygon(Tb)
points(Xp)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{runif.std.tri}}, \code{\link{runif.tri}},
and \code{\link{runif.multi.tri}}
}
\author{
Elvan Ceyhan
}
