% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{runif.std.tetra}
\alias{runif.std.tetra}
\title{Generation of Uniform Points
in the Standard Regular Tetrahedron \eqn{T_h}}
\usage{
runif.std.tetra(n)
}
\arguments{
\item{n}{A positive integer
representing the number of uniform points to be generated in the
standard regular tetrahedron \eqn{T_h}.}
}
\value{
A \code{list} with the elements
\item{type}{The type of the pattern
from which points are to be generated}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{tess.points}{The vertices of the support region
of the uniformly generated points, it is the
standard regular tetrahedron \eqn{T_h} for this function}
\item{gen.points}{The output set of generated points uniformly
in the standard regular tetrahedron \eqn{T_h}.}
\item{out.region}{The outer region which contains the support region,
\code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern
from which points are to be generated}
\item{num.points}{The \code{vector} of two numbers,
which are the number of generated points and the number
of vertices of the support points (here it is 4).}
\item{txt4pnts}{Description of the two numbers in \code{num.points}}
\item{xlimit,ylimit,zlimit}{The ranges of the \eqn{x}-, \eqn{y}-,
and \eqn{z}-coordinates of the support, \eqn{T_h}}
}
\description{
An object of class \code{"Uniform"}.
Generates \code{n} points uniformly in the standard regular tetrahedron
\eqn{T_h=T((0,0,0),(1,0,0),(1/2,\sqrt{3}/2,0),(1/2,\sqrt{3}/6,\sqrt{6}/3))}.
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-100

set.seed(1)
Xdt<-runif.std.tetra(n)
Xdt
summary(Xdt)
plot(Xdt)

Xp<-runif.std.tetra(n)$g

Xlim<-range(tetra[,1])
Ylim<-range(tetra[,2])
Zlim<-range(tetra[,3])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::scatter3D(Xp[,1],Xp[,2],Xp[,3],
phi =20,theta=15, bty = "g", pch = 20, cex = 1,
ticktype = "detailed",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05),
zlim=Zlim+zd*c(-.05,.05))
#add the vertices of the tetrahedron
plot3D::points3D(tetra[,1],tetra[,2],tetra[,3], add=TRUE)
L<-rbind(A,A,A,B,B,C); R<-rbind(B,C,D,C,D,D)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],
add=TRUE,lwd=2)

plot3D::text3D(tetra[,1]+c(.05,0,0,0),tetra[,2],tetra[,3],
labels=c("A","B","C","D"), add=TRUE)
}

\dontrun{
#need to install scatterplot3d package and call "library(scatterplot3d)"
s3d<-scatterplot3d(Xp, highlight.3d=TRUE,xlab="x",
ylab="y",zlab="z",
              col.axis="blue", col.grid="lightblue",
               main="3D Scatterplot of the data", pch=20)
s3d$points3d(tetra,pch=20,col="blue")
}

}
\seealso{
\code{\link{runif.tetra}}, \code{\link{runif.tri}},
and \code{\link{runif.multi.tri}}
}
\author{
Elvan Ceyhan
}
