% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthocfuns.R
\name{varimp.pcoxtime}
\alias{varimp.pcoxtime}
\alias{varimp}
\title{Compute variable or coefficient importance score}
\usage{
\method{varimp}{pcoxtime}(
  object,
  newdata,
  type = c("coef", "perm", "model"),
  relative = TRUE,
  nrep = 50,
  parallelize = FALSE,
  nclusters = 1,
  estimate = c("mean", "quantile"),
  probs = c(0.025, 0.5, 0.975),
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{fitted \code{\link[pcoxtime]{pcoxtime}}.}

\item{newdata}{data frame containing the variables appearing on the right hand side of \code{\link[pcoxtime]{pcoxtime}} formula.}

\item{type}{if \code{type = "coef"} or \code{type = "model"} absolute value of estimated coefficients is computed. If \code{type = "perm"} variable level importance is computed using permutation.}

\item{relative}{logical. If \code{TRUE} the scores are divided by the absolute sum of the coefficients.}

\item{nrep}{number of replicates for permutations. Default is \code{nrep = 50}.}

\item{parallelize}{whether to run in parallel. Default is \code{FALSE}.}

\item{nclusters}{number of cores to use if \code{parallelize = TRUE}.}

\item{estimate}{character string specify which summary statistic to use for the estimates. Default is \code{"mean"}.}

\item{probs}{numeric vector of probabilities with values in \code{[0,1]}.}

\item{seed}{a single value for for random number generation.}

\item{...}{for future implementation.}
}
\value{
a named vector of variable scores (\code{estimate = "mean"}) or a data frame (\code{estimate = "quantile"}).
}
\description{
Compute variable or coefficient importance score
}
\details{
Absolute value of the coefficients (parameters) corresponding the \code{\link[pcoxtime]{pcoxtime}} object (\code{type = "coef"}). Otherwise, variable level importance is computed using permutation (\code{type = "perm"}).
In the case of permutation: given predictors \code{x_1, x_2, ..., x_n} used to predict the survival outcome, \code{y}. Suppose, for example, \code{x_1} has low predictive power for the response. Then, if we randomly permute the observed values for \code{x_1}, then the prediction for \code{y} will not change much. Conversely, if any of the predictors highly predicts the response, the permutation of that specific predictor will lead to a considerable change in the predictive measure of the model. In this case, we conclude that this predictor is important. In our implementation, Harrel's concordance index is used to measure the prediction accuracy.
}
\examples{

if (packageVersion("survival")>="3.2.9") {
   data(cancer, package="survival")
} else {
   data(veteran, package="survival")
}
# Penalized
lam <- 0.1
alp <- 0.5
pfit1 <- pcoxtime(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, lambda = lam
	, alpha = alp
)
imp1 <- varimp(pfit1, veteran)
plot(imp1)
}
