% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoxtimeplots.R
\name{plot.Score}
\alias{plot.Score}
\title{Prediction performance}
\usage{
\method{plot}{Score}(x, ..., type = c("roc", "auc", "brier"), pos = 0.3)
}
\arguments{
\item{x}{\code{\link[riskRegression]{Score}} object. See examples.}

\item{...}{for future implementations.}

\item{type}{metric to return. Choices are \code{"roc", "auc", "brier"}.}

\item{pos}{spacing between the lines.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots predictive performance of \code{pcoxtime} in comparison to other models. It uses risk scoring from \code{\link[riskRegression]{Score}}. \code{pcoxtime} also supports performance measure scoring by R package \code{pec}. See examples.
}
\details{
Implements plot method for \code{\link[riskRegression]{Score}} for time-dependent Brier score, AUC and ROC. However, currently, no support for time-dependent covariate models.
}
\examples{

if (packageVersion("survival")>="3.2.9") {
   data(cancer, package="survival")
} else {
   data(veteran, package="survival")
}
# pcoxtime
lam <- 0.1
alp <- 1
pfit1 <- pcoxtime(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, lambda = lam 
	, alpha = alp
)

# coxph 
cfit1 <- coxph(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, method = "breslow" 
	, x = TRUE
	, y = TRUE
)

# Evaluate model performance at 90, 180, 365 time points
score_obj <- Score(list("coxph" = cfit1, "pcox" = pfit1)
	, Surv(time, status) ~ 1
	, data = veteran
	, plots = "roc"
	, metrics = c("auc", "brier")
	, B = 10
	, times = c(90, 180, 365)
)

# Plot AUC
plot(score_obj, type = "auc")
# Plot ROC
plot(score_obj, type = "roc")
# Plot brier
plot(score_obj, type = "brier")

# Prediction error using pec package
\dontrun{
	if (require("pec")) {
		pec_fit <- pec(list("coxph" = cfit1, "pcox" = pfit1)
			, Surv(time, status) ~ 1
			, data = veteran
			, splitMethod = "Boot632plus"
			, keep.matrix = TRUE
		)
		plot(pec_fit)
	}
}

}
