% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing_fun.R
\name{pcr_lm}
\alias{pcr_lm}
\title{Linear regression qPCR data}
\usage{
pcr_lm(df, group_var, reference_gene, reference_group, model_matrix = NULL,
  ...)
}
\arguments{
\item{df}{A data.frame of \eqn{C_T} values with genes in the columns and samples
in rows rows}

\item{group_var}{A character vector of a grouping variable. The length of
this variable should equal the number of rows of df}

\item{reference_gene}{A character string of the column name of a control gene}

\item{reference_group}{A character string of the control group in group_var}

\item{model_matrix}{A model matrix for advanced experimental design. for
constructing such a matrix with different variables check
\code{\link[stats]{model.matrix}}}

\item{...}{Other arguments to \code{\link[stats]{lm}}}
}
\value{
A data.frame of 6 columns
\itemize{
  \item term The term being tested
  \item gene The column names of df. reference_gene is dropped
  \item estimate The estimate for each term
  \item p_value The p-value for each term
  \item lower The low 95\% confidence interval
  \item upper The high 95\% confidence interval
}
}
\description{
Linear regression qPCR data
}
\examples{
# locate and read data
fl <- system.file('extdata', 'ct4.csv', package = 'pcr')
ct4 <- readr::read_csv(fl)

# make group variable
group <- rep(c('control', 'treatment'), each = 12)

# test
pcr_lm(ct4,
       group_var = group,
       reference_gene = 'ref',
       reference_group = 'control')

# testing using lm method
pcr_test(ct4,
         group_var = group,
         reference_gene = 'ref',
         reference_group = 'control',
         test = 'lm')

}
