% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco_micro.R
\name{RCbray1}
\alias{RCbray1}
\title{Calculate RCbray-curtis}
\usage{
RCbray1(
  otutab,
  reps = 9,
  threads = 1,
  classic_metric = TRUE,
  split_ties = TRUE
)
}
\arguments{
\item{otutab}{otutab}

\item{reps}{how many simulation performed?}

\item{threads}{use how many threads to calculate (default:4)}

\item{classic_metric}{standardizes the metric to range from -1 to 1}

\item{split_ties}{adds half of the number of null observations that are equal to the observed number of shared species to the calculation- this is highly recommended}
}
\value{
a dist
}
\description{
Calculate RCbray-curtis
}
\details{
Parallelized version of the Raup-Crick algorithm for "abundance" data (Stegen et al. 2013).
}
\examples{
\donttest{
if (requireNamespace("picante")) {
  data(otutab, package = "pcutils")
  df2tree(taxonomy) -> phylo
  b_NTI1(phylo, otutab) -> bnti_res
  RCbray1(otutab, reps = 9) -> rc_res

  data.frame(
    type = factor(c("Homo_S", "Heter_S", "Homo_D", "D_limit", "Undominated"),
      levels = c("Homo_S", "Heter_S", "Homo_D", "D_limit", "Undominated")
    ),
    number = c(
      sum(bnti_res < (-2)), sum(bnti_res > 2),
      sum((abs(bnti_res) < 2) & (abs(rc_res) < 0.95)),
      sum((abs(bnti_res) < 2) & (rc_res < (-0.95))),
      sum((abs(bnti_res) < 2) & (rc_res > 0.95))
    )
  ) -> com_pro
  pcutils::gghuan(com_pro, reorder = FALSE)
}
}
}
