% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_analyse.R
\name{permanova}
\alias{permanova}
\title{Permanova between a otutab and a variable}
\usage{
permanova(
  otutab,
  envs,
  norm = TRUE,
  each = TRUE,
  method = "adonis",
  dist = "bray",
  nperm = 999,
  ...
)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{envs}{factors need to test}

\item{norm}{should normalize?(default:TRUE)}

\item{each}{test factor one by one, rather than whole}

\item{method}{adonis/mrpp/anosim/mantel}

\item{dist}{if use pcoa or nmds, your can choose a dist method (default: bray)}

\item{nperm}{numbers of permutations to perform}

\item{...}{additional}
}
\value{
a g_test object with these columns
\item{group}{the test group or factor}
\item{r}{relationship}
\item{r2}{model R-square}
\item{p_value}{model test p_value}
\item{sig}{whether significant}
}
\description{
Permanova between a otutab and a variable
}
\examples{
data(otutab, package = "pcutils")
permanova(otutab, metadata[, c(2:10)]) -> adonis_res
print(adonis_res)
plot(adonis_res)
}
\references{
\url{https://blog.csdn.net/qq_42458954/article/details/110390488}
}
