% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pdqr_approx_error}
\alias{pdqr_approx_error}
\title{Diagnose pdqr approximation}
\usage{
pdqr_approx_error(f, ref_f, ..., gran = 10, remove_infinity = TRUE)
}
\arguments{
\item{f}{A p-, d-, or q-function to diagnose. Usually the output of one of
\code{\link[=as_p]{as_p()}}, \code{\link[=as_d]{as_d()}}, or \code{\link[=as_q]{as_q()}} default methods.}

\item{ref_f}{A "true" distribution function of the same \link[=meta_class]{class}
as \code{f}. Usually the input to the aforementioned \code{as_*()} function.}

\item{...}{Other arguments to \code{ref_f}. If they were supplied to \code{as_*()}
function, then the exact same values must be supplied here.}

\item{gran}{Degree of grid "granularity" in case of "continuous" type: number
of subintervals to be produced inside every interval of density linearity.
Should be not less than 1 (indicator that original column from
\link[=meta_x_tbl]{"x_tbl"} will be used, see details).}

\item{remove_infinity}{Whether to remove rows corresponding to infinite
error.}
}
\value{
A data frame with the following columns:
\itemize{
\item \strong{grid} <dbl> : A grid at which errors are computed.
\item \strong{error} <dbl> : Errors which are computed as \code{ref_f(grid, ...) - f(grid)}.
\item \strong{abserror} <dbl> : Absolute value of "error" column.
}
}
\description{
\code{pdqr_approx_error()} computes errors that are results of 'pdqr'
approximation, which occurs because of possible tail trimming and assuming
piecewise linearity of density function in case of "continuous" type. For an
easy view summary, use \link[base:summary]{summary()}.
}
\details{
Errors are computed as difference between "true" value (output of
\code{ref_f}) and output of pdqr-function \code{f}. They are computed at "granulated"
\code{gran} times grid (which is an "x" column of "x_tbl" in case \code{f} is p- or
d-function and "cumprob" column if q-function). They are usually negative
because of possible tail trimming of reference distribution.

\strong{Notes}:
\itemize{
\item \code{gran} argument for "discrete" type is always 1.
\item Quantile pdqr approximation of "discrete" distribution with infinite
tale(s) can result into "all one" summary of error. This is expected output
and is because test grid is chosen to be quantiles of pdqr-distribution which
due to renormalization can differ by one from reference ones. For example:
\code{summary(pdqr_approx_error(as_p(ppois, lambda = 10), ppois, lambda = 10))}.
}
}
\examples{
d_norm <- as_d(dnorm)
error_norm <- pdqr_approx_error(d_norm, dnorm)
summary(error_norm)

# Setting `gran` results into different number of rows in output
error_norm_2 <- pdqr_approx_error(d_norm, dnorm, gran = 1)
nrow(meta_x_tbl(d_norm)) == nrow(error_norm_2)

# By default infinity errors are removed
d_beta <- as_d(dbeta, shape1 = 0.3, shape2 = 0.7)
error_beta_1 <- pdqr_approx_error(d_beta, dbeta, shape1 = 0.3, shape2 = 0.7)
summary(error_beta_1)

# To not remove them, set `remove_infinity` to `FALSE`
error_beta_2 <- pdqr_approx_error(
  d_beta, dbeta, shape1 = 0.3, shape2 = 0.7, remove_infinity = FALSE
)
summary(error_beta_2)

}
\seealso{
\code{\link[=enpoint]{enpoint()}} for representing pdqr-function as a set of points with
desirable number of rows.
}
