% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_fitMethods.R
\name{optimIn}
\alias{optimIn}
\title{Extract Input Parameters of Numeric Optimization of Fitted Model.}
\usage{
optimIn(object, ...)
}
\arguments{
\item{object}{An object for which input parameters of numeric
optimization are desired.}

\item{...}{further arguments.}
}
\value{
\code{optimIn} extracts input parameters used in numeric
   optimization from object.
}
\description{
\code{optimIn} is a generic function for extracting input parameters
   of numeric optimization for an object.
}
\examples{
## Load data from plm package
if(!requireNamespace("plm", quietly = TRUE)){
 stop("Dataset from package \"plm\" needed for this example.
 Please install the package.", call. = FALSE)
} else{
 data(EmplUK, package = "plm")
 dat <- EmplUK
 dat[,c(4:7)] <- log(dat[,c(4:7)])
 dat <- dat[c(1:140), ]

## Code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
    opt.meth = "none")
 optimIn(m1)
}

\donttest{
## Load data from plm package
if(!requireNamespace("plm", quietly = TRUE)){
 stop("Dataset from package \"plm\" needed for this example.
 Please install the package.", call. = FALSE)
} else{
 data(EmplUK, package = "plm")
 dat <- EmplUK
 dat[,c(4:7)] <- log(dat[,c(4:7)])

## Further code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
    opt.meth = "BFGS")
 optimIn(m1)
}
}


}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
\author{
Markus Fritsch
}
